<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CaixaDeEntrada
 *
 * @author WEBLAB
 */
class NewsLetter {

    private $Data;
    private $Post;
    private $Error;
    private $Result;

    const Entity = "ws_newsletter";

    public function ExeCreate(array $Data) {
        $this->Data = $Data;

        $this->setData();
        $this->Create();
    }

    public function ExeUpdate($PostId, array $Data) {
        $this->Post = (int) $PostId;
        $this->Data = $Data;

        $this->setData();
        $this->Update();
    }
    
     public function ExeStatus($PostId, $PostStatus) {
        $this->Post = (int) $PostId;
        $this->Data['news_status'] = (string) $PostStatus;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE news_id = :id", "id={$this->Post}");
    }

    public function ExeDelete($PostId) {
        $this->Post = (int) $PostId;

        $ReadPost = new Read;
        $ReadPost->ExeRead(self::Entity, "WHERE news_id = :codigo", "codigo={$this->Post}");

        if (!$ReadPost->getResult()):
            $this->Error = ["Os dados que você tentou deletar não existe no sistema!", WS_ERROR];
            $this->Result = false;
        else:
            $PostDelete = $ReadPost->getResult()[0];

            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE news_id = :cod", "cod={$this->Post}");

            $this->Error = ["Os dados foram removidos com sucesso do sistema!", WS_ACCEPT];
            $this->Result = true;

        endif;
    }

    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    private function setData() {
        $check = new Check();

        $this->Data = array_map("strip_tags", $this->Data);
        $this->Data = array_map("trim", $this->Data);
        $this->Data['news_date'] = date('Y-m-d');
    }


    private function Create() {
        $cadastra = new Create();
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()):
            $this->Error = ["Inscrição realizada com sucesso!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    private function Update() {
        $Update = new Update();
        $Update->ExeUpdate(self::Entity, $this->Data, "where news_id = :cod", "cod={$this->Post}");
        if ($Update->getResult()):
            $this->Error = ["Inscrição atualizada com sucesso!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
