<?php

/**
 * AdminCategory.class [ MODEL ADMIN ]
 * Responável por gerenciar as categorias do sistema no admin!
 * 
 * @copyright (c) 2017, Alisson Maciel
 */
class AdminCategory {

    private $Data;
    private $CatId;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados!
    const Entity = 'ws_categories';

    /**
     * <b>Cadastrar Categoria:</b> Envelope titulo, descrição, data e sessão em um array atribuitivo e execute esse método
     * para cadastrar a categoria. Case seja uma sessão, envie o category_parent como STRING null.
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;

        $this->setData();
        $this->setName();
        $this->Create();
    }

    /**
     * <b>Atualizar Categoria:</b> Envelope os dados em uma array atribuitivo e informe o id de uma
     * categoria para atualiza-la!
     * @param INT $CategoryId = Id da categoria
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($CategoryId, array $Data) {
        $this->CatId = (int) $CategoryId;
        $this->Data = $Data;

        $this->setData();
        $this->setName();
        $this->Update();
    }

    /**
     * <b>Deleta categoria:</b> Informe o ID de uma categoria para remove-la do sistema. Esse método verifica
     * o tipo de categoria e se é permitido excluir de acordo com os registros do sistema!
     * @param INT $CategoryId = Id da categoria
     */
    public function ExeDelete($CategoryId) {
        $this->CatId = (int) $CategoryId;

        $read = new Read;
        $read->ExeRead(self::Entity, "WHERE category_id = :delid", "delid={$this->CatId}");

        if (!$read->getResult()):
            $this->Result = false;
            $this->Error = ['Oppsss, você tentou remover uma categoria que não existe no sistema!', WS_INFOR];
        else:
            $extract = $read->getResult()[0];
            if (!$extract->category_parent && !$this->checkCats()):
                $this->Result = false;
                $this->Error = ["A <b>seção {$extract->category_title}</b> possui categorias cadastradas. Para deletar, antes altere ou remova as categorias filhas!", WS_ALERT];
//            elseif ($extract->category_parent && !$this->checkPosts()):
//                $this->Result = false;
//                $this->Error = ["A <b>categoria {$extract->category_title}</b> possui artigos cadastrados. Para deletar, antes altere ou remova todos os posts desta categoria!", WS_ALERT];
            else:
                $delete = new Delete;
                $delete->ExeDelete(self::Entity, "WHERE category_id = :deletaid", "deletaid={$this->CatId}");

                $tipo = ( empty($extract->category_parent) ? 'seção' : 'categoria' );
                $this->Result = true;
                $this->Error = ["A <b>{$tipo} {$extract->category_title}</b> foi removida com sucesso do sistema!", WS_ACCEPT];
            endif;
        endif;
    }

    public function ExeStatus($PostId, $PostStatus) {
        $this->Post = (int) $PostId;
        $this->Data['category_status'] = (string) $PostStatus;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE category_id = :id", "id={$this->Post}");
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna TRUE se o cadastro ou update for efetuado ou FALSE se não. Para verificar
     * erros execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com a mensagem e o tipo de erro!
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida e cria os dados para realizar o cadastro
    private function setData() {
        $Check = new Check;
        $this->Data = array_map('strip_tags', $this->Data);
        $this->Data = array_map('trim', $this->Data);
        $this->Data['category_name'] = $Check->Name($this->Data['category_title']);
        $this->Data['category_parent'] = ($this->Data['category_parent'] == 'null' ? null : $this->Data['category_parent']);
    }

    //Verifica o NAME da categoria. Se existir adiciona um pós-fix +1
    private function setName() {
        $Where = (!empty($this->CatId) ? "category_id != {$this->CatId} AND" : '' );

        $readName = new Read;
        $readName->ExeRead(self::Entity, "WHERE {$Where} category_title = :t", "t={$this->Data['category_title']}");
        if ($readName->getResult()):
            $this->Data['category_name'] = $this->Data['category_name'] . '-' . $readName->getRowCount();
        endif;
    }

    //Verifica categorias da seção
    private function checkCats() {
        $readSes = new Read;
        $readSes->ExeRead(self::Entity, "WHERE category_parent = :parent", "parent={$this->CatId}");
        if ($readSes->getResult()):
            return false;
        else:
            return true;
        endif;
    }

    //Verifica artigos da categoria
    private function checkPosts() {
        $readPosts = new Read;
        $readPosts->ExeRead("ws_posts", "WHERE post_category = :category", "category={$this->CatId}");
        if ($readPosts->getResult()):
            return false;
        else:
            return true;
        endif;
    }

    //Cadastra a categoria no banco!
    private function Create() {
        $this->Data['category_date'] = date('Y-m-d H:i:s');
        $Create = new Create;
        $Create->ExeCreate(self::Entity, $this->Data);
        if ($Create->getResult()):
            $this->Result = $Create->getResult();
            $this->Error = ["<b>Sucesso:</b> A categoria {$this->Data['category_title']} foi cadastrada no sistema!", WS_ACCEPT];
        endif;
    }

    //Atualiza Categoria
    private function Update() {
        $this->Data['category_date'] = date('Y-m-d H:i:s');
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE category_id = :catid", "catid={$this->CatId}");
        if ($Update->getResult()):
            $tipo = ( empty($this->Data['category_parent']) ? 'sessão' : 'categoria' );
            $this->Result = true;
            $this->Error = ["<b>Sucesso:</b> A {$tipo} {$this->Data['category_title']} foi atualizada no sistema!", WS_ACCEPT];
        endif;
    }

    public static function exibe_filhos($id_categoria, $indent = '') {
        $type = 'categoria';
        $read = new Read;
        $read->ExeRead(self::Entity, "where category_parent = :pai and category_type = :type", "pai={$id_categoria}&type={$type}");

        foreach ($read->getResult() as $l) {
            echo "<option value='{$l->category_id}'>{$indent} {$l->category_title}</option>";
            return self::exibe_filhos($l->category_id, $indent . $indent);
        }
    }

    public static function lista_filhos($id_categoria, $indent = '', $admin = '') {
        $type = 'categoria';
        $read = new Read;
        $read->ExeRead(self::Entity, "where category_parent = :pai", "pai={$id_categoria}");

        foreach ($read->getResult() as $l) {
            $status = (!$l->category_status) ? '<span class="badge bg-important">&nbsp;</span> <span class="text-danger">Inativo</span>' : '<span class="badge bg-success">&nbsp;</span> <span class="text-success">Ativo</span>';
            echo " 
                <tr class=\"gradeU\">
                    <td>{$indent} {$l->category_title}</td>
                    <td>{$status}</td>
                    <td>
                        <a class=\"btn btn-primary btn-xs\" href=\"{$admin}/posts/categorias-editar/{$l->category_id}\" title=\"Editar esta categoria\">
                            <i class=\"fa fa-edit\"></i> 
                        </a>
                        <a class=\"btn btn-danger btn-xs\" href=\"{$admin}/posts/categorias/{$l->category_id}&acao=delete\" title=\"Excluir esta categoria\">
                            <i class=\"fa fa-trash-o\"></i> 
                        </a>
                    </td>
                </tr>";
            return self::lista_filhos($l->category_id, $indent . $indent, $admin);
        }
    }

    public static function lista_filhos_excluir($id_categoria, $indent = '', $admin = '', $id = '') {
        $type = 'categoria';

        $readRelationShips = new Read;
        $readRelationShips->ExeRead("ws_category_post", "where post_id = :id", "id={$id}");
        if ($readRelationShips->getResult()):
            foreach ($readRelationShips->getResult() as $RelationShips):
                $read = new Read;
                $read->ExeRead(self::Entity, "where category_id = :pai and category_type = :type", "pai={$RelationShips->category_id}&type={$type}");
                if ($read->getResult()):
                    $l = $read->getResult()[0];
                    echo "<a class=\"btn btn-danger btn-xs\" href=\"{$admin}/posts/editar/{$id}/{$RelationShips->id}\">{$indent} {$l->category_title} <i class=\"fa fa-trash-o\"></i></a><br>";
                endif;
return self::lista_filhos_excluir($RelationShips->category_id, $indent . $indent, $admin, $id);
            endforeach;
            
        endif;
    }

}
