<?php
/**
 * Email [ MODEL ]
 * Modelo responável por configurar a PHPMailer, validar os dados e disparar e-mails do sistema!
 * 
* @copyright (c) 2015, Alisson Maciel AGÊNCIA DIGITAL WEB LAB
 */
class EmailRetorno {

    /** @var PHPMailer */
    private $Mail;

    /** EMAIL DATA */
    private $Data;

    /** CORPO DO E-MAIL */
    private $Assunto;
    private $Mensagem;

    /** REMETENTE */
    private $RemetenteNome;
    private $RemetenteEmail;

    /** DESTINO */
    private $DestinoNome;
    private $DestinoEmail;

    /** CONSTROLE */
    private $Error;
    private $Result;

    function __construct() {
        if(MAILSECURE == 'true'):
            $true = true;
        else:
            $true = false;
        endif;
        $this->Mail = new PHPMailer;
        $this->Mail->Host = MAILHOST;
        $this->Mail->Port = MAILPORT;
        $this->Mail->Username = MAILUSER;
        $this->Mail->Password = MAILPASS;
        $this->Mail->SMTPAuth = $true;
        $this->Mail->SMTPSecure = 'tls';
    }

    /**
     * <b>Enviar E-mail SMTP:</b> Envelope os dados do e-mail em um array atribuitivo para povoar o mÃ©todo.
     * Com isso execute este para ter toda a validaÃ§Ã£o de envio do e-mail feita automaticamente.
     * 
     * <b>REQUER DADOS ESPECÃ�FICOS:</b> Para enviar o e-mail vocÃª deve montar um array atribuitivo com os
     * seguintes Ã­ndices corretamente povoados:<br><br>
     * <i>
     * &raquo; Assunto<br>
     * &raquo; Mensagem<br>
     * &raquo; RemetenteNome<br>
     * &raquo; RemetenteEmail<br>
     * &raquo; DestinoNome<br>
     * &raquo; DestinoEmail
     * </i>
     */
    public function Enviar(array $Data) {
        $this->Data = $Data;
        $this->Clear();
        $check = new Check;

        if (in_array('', $this->Data)):
            $this->Error = "<b>ERRO AO ENVIAR E-MAIL:</b> Dados informados são insuficientes para disparo de mensagem!";
            $this->Result = false;
        elseif (!$check->Email($this->Data['RemetenteEmail'])):
            $this->Error = "<b>ERRO AO ENVIAR E-MAIL:</b> O endereço de e-mail informado para o remetente n~~ao tem um formato válido!";
            $this->Result = false;
        else:
            $Data['RemetenteNome'] = ($Data['RemetenteNome'] != 'null' ? $Data['RemetenteNome'] : null);
            $this->setMail();
            $this->Config();
            $this->sendMail();
        endif;
    }

    /**
     * <b>Montar e Enviar:</b> Execute este mÃ©todo para facilitar o envio. Informando os parÃ¢metros solicitados para montar a data! 
     */
    public function EnviarMontando($Assunto, $Mensagem, $RemetenteNome, $RemetenteEmail, $DestinoNome, $DestinoEmail) {
        $Data['Assunto'] = $Assunto;
        $Data['Mensagem'] = $Mensagem;
        $Data['RemetenteNome'] = $RemetenteNome;
        $Data['RemetenteEmail'] = $RemetenteEmail;
        $Data['DestinoNome'] = $DestinoNome;
        $Data['DestinoEmail'] = $DestinoEmail;
        $this->Enviar($Data);
    }

    /**
     * <b>Verificar Envio:</b> Executando um getResult Ã© possÃ­vel verificar se foi ou nÃ£o efetuado 
     * o envio do e-mail. Para mensagens execute o getError();
     * @return BOOL $Result = TRUE or FALSE
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com o erro e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    private function Clear() {
        array_map('trim', $this->Data);
    }

    private function setMail() {
        $this->Assunto = $this->Data['Assunto'];
        $this->Mensagem = $this->Data['Mensagem'];
        $this->RemetenteNome = $this->Data['RemetenteNome'];
        $this->RemetenteEmail = $this->Data['RemetenteEmail'];
        $this->DestinoNome = $this->Data['DestinoNome'];
        $this->DestinoEmail = $this->Data['DestinoEmail'];
        $this->Data = null;
    }

    private function Config() {
        /*SMTP AUTH*/
        $this->Mail->CharSet = 'utf-8';
        $this->Mail->setLanguage('pt');
        $this->Mail->IsSMTP();
        $this->Mail->IsHTML(true);


        /*REMETENTE E RETORNO*/
        $this->Mail->From = $this->RemetenteEmail;
        $this->Mail->FromName = $this->RemetenteNome;
        $this->Mail->AddReplyTo($this->RemetenteEmail, $this->RemetenteNome);

        /*ASSUNTO, MENSAGEM E DESTINO*/
        $this->Mail->Subject = $this->Assunto;
        $this->Mail->msgHTML($this->Mensagem);
        $this->Mail->AddAddress($this->DestinoEmail, $this->DestinoNome);
    }

    /*Envia o e-mail!*/
    private function sendMail() {
        if ($this->Mail->Send()):
            $this->Error = null;
            $this->Result = true;

            $this->Mail->clearAddresses();
        else:
            $this->Error = '<b>ERRO AO ENVIAR E-MAIL:</b> ' . $this->Mail->ErrorInfo;
            $this->Result = false;
        endif;
    }

}