<?php

/**
 * AdminCategory.class [ MODEL ADMIN ]
 * Responável por gerenciar as categorias do sistema no admin!
 * 
 * @copyright (c) 2015, Alisson Maciel AGÊNCIA DIGITAL WEB LAB
 */
class AdminSubcategory {

    private $Data;
    private $SubCatId;
    private $SubCatSlug;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados!
    const Entity = "loja_subcategorias";

    /**
     * <b>Cadastrar Categoria:</b> Envelope titulo, descrição, data e sessão em um array atribuitivo e execute esse método
     * para cadastrar a categoria. Case seja uma sessão, envie o category_parent como STRING null.
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;

        if (in_array('', $this->Data)):
            $this->Result = false;
            $this->Error = ['<b>Erro ao cadastrar:</b> Para cadastrar uma subcategoria, insira um nome de subcategoria!', WS_ALERT];
        else:
            $this->setData();
            $this->setName();
            $this->Create();
        endif;
    }

    /**
     * <b>Atualizar Categoria:</b> Envelope os dados em uma array atribuitivo e informe o id de uma
     * categoria para atualiza-la!
     * @param INT $CategoryId = Id da categoria
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($SubcategoryId, array $Data) {
        $this->SubCatId = (int) $SubcategoryId;
        $this->Data = $Data;

        if (in_array('', $this->Data)):
            $this->Result = false;
            $this->Error = ["<b>Erro ao atualizar:</b> Para atualizar a subcategoria {$this->Data['tituloSubcategoria']}, insira um nome de subcategoria!", WS_ALERT];
        else:
            $this->setData();
            $this->setName();
            $this->Update();
        endif;
    }

    /**
     * <b>Deleta categoria:</b> Informe o ID de uma categoria para remove-la do sistema. Esse método verifica
     * o tipo de categoria e se é permitido excluir de acordo com os registros do sistema!
     * @param INT $CategoryId = Id da categoria
     */
    public function ExeDelete($SubcategoryId) {
        $this->SubCatId = (int) $SubcategoryId;

        $read = new Read;
        $read->ExeRead(self::Entity, "WHERE idSubcategoria = :delid", "delid={$this->SubCatId}");

        if (!$read->getResult()):
            $this->Result = false;
            $this->Error = ['Oppsss, você tentou remover uma subcategoria que não existe no sistema!', WS_INFOR];
        else:
            extract($read->getResult()[0]);
            if ($slugSubcategoria && !$this->checkProdutos()):
                $this->Result = false;
                $this->Error = ["A <b>subcategoria {$tituloSubcategoria}</b> possui produtos cadastrados. Para deletar, antes altere ou remova todos os produtos desta subcategoria!", WS_ALERT];
            else:
                $delete = new Delete;
                $delete->ExeDelete(self::Entity, "WHERE idSubcategoria = :deletaid", "deletaid={$this->SubCatId}");

                $this->Result = true;
                $this->Error = ["A <b>Subcategoria {$tituloSubcategoria}</b> foi removida com sucesso do sistema!", WS_ACCEPT];
            endif;
        endif;
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna TRUE se o cadastro ou update for efetuado ou FALSE se não. Para verificar
     * erros execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com a mensagem e o tipo de erro!
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida e cria os dados para realizar o cadastro
    private function setData() {
        $this->Data = array_map('strip_tags', $this->Data);
        $this->Data = array_map('trim', $this->Data);
        $this->Data['slugSubcategoria'] = Check::Name($this->Data['tituloSubcategoria']);
    }

    //Verifica o NAME da categoria. Se existir adiciona um pós-fix +1
    private function setName() {
        $Where = (!empty($this->SubCatId) ? "idSubcategoria != {$this->SubCatId} AND" : '' );

        $readName = new Read;
        $readName->ExeRead(self::Entity, "WHERE {$Where} tituloSubcategoria = :t", "t={$this->Data['tituloSubcategoria']}");
        if ($readName->getResult()):
            $this->Data['slugSubcategoria'] = $this->Data['slugSubcategoria'] . '-' . $readName->getRowCount();
        endif;
    }
    
    //Verifica artigos da categoria
    private function checkProdutos() {
        $readPosts = new Read;
        $readPosts->ExeRead("loja_produtos", "WHERE subcategoriaProduto = :category", "category={$this->SubCatSlug}");
        if ($readPosts->getResult()):
            return false;
        else:
            return true;
        endif;
    }

    //Cadastra a categoria no banco!
    private function Create() {
        $Create = new Create;
        $Create->ExeCreate(self::Entity, $this->Data);
        if ($Create->getResult()):
            $this->Result = $Create->getResult();
            $this->Error = ["<b>Sucesso:</b> A subcategoria {$this->Data['tituloSubcategoria']} foi cadastrada no sistema!", WS_ACCEPT];
        endif;
    }

    //Atualiza Categoria
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE idSubcategoria = :catid", "catid={$this->SubCatId}");
        if ($Update->getResult()):
            $this->Result = true;
            $this->Error = ["<b>Sucesso:</b> A subcategoria {$this->Data['tituloSubcategoria']} foi atualizada no sistema!", WS_ACCEPT];
        endif;
    }

}
