<?php

/**
 * AdminPost.class [ MODEL ADMIN ]
 * Respnsável por gerenciar os posts no Admin do sistema!
 * 
 * @copyright (c) 2014, Alisson MAciel
 */
class AdminPost {

    private $Data;
    private $Post;
    private $Error;
    private $Result;
    private $Type;

    const Entity = 'ws_posts';

    public function PostType($Type) {
        $this->Type = (string) $Type;
    }

    /**
     * <b>Cadastrar o Post:</b> Envelope os dados do post em um array atribuitivo e execute esse método
     * para cadastrar o post. Envia a capa automaticamente!
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;

        $this->setData();
        $this->setName();
        $this->Create();
    }

    /**
     * <b>Atualizar Post:</b> Envelope os dados em uma array atribuitivo e informe o id de um 
     * post para atualiza-lo na tabela!
     * @param INT $PostId = Id do post
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($PostId, array $Data) {
        $this->Post = (int) $PostId;
        $this->Data = $Data;

        $this->setData();
        $this->setName();
        $this->Update();
    }

    /**
     * <b>Deleta Post:</b> Informe o ID do post a ser removido para que esse método realize uma checagem de
     * pastas e galerias excluinto todos os dados nessesários!
     * @param INT $PostId = Id do post
     */
    public function SendVideo(array $Data) {
        $this->Data = $Data;
        $this->Post = $this->Data['post_id'];
        $ImageName = new Read;
        $ImageName->ExeRead(self::Entity, "WHERE post_id = :id", "id={$this->Post}");

        if (!$ImageName->getResult()):
            $this->Error = ["Erro ao enviar video. O índice {$this->Post} não foi encontrado no banco!", WS_ERROR];
            $this->Result = false;
        else:
            $i = 1;
            $i++;
            $ImageName = $ImageName->getResult()[0]->post_name . '-video';
            $ImgName = "{$ImageName}-gb-{$this->Post}-" . (substr(md5(time() + $i), 0, 5));

            if ($this->Data['gallery_image']):
                $uplaod = new Upload;
                $uplaod->Media($this->Data['gallery_image'], $ImgName);
            endif;

            if (isset($uplaod) && $uplaod->getResult()):
                $this->Data['gallery_image'] = $uplaod->getResult();
                $this->CreateVideo();
            else:
                $this->Data['gallery_image'] = null;
                $this->CreateVideo();
            endif;
        endif;
    }

    private function CreateVideo() {
        $this->Data['gallery_status'] = 'video';
        $cadastra = new Create;
        $cadastra->ExeCreate("ws_posts_gallery", $this->Data);
        if ($cadastra->getResult()):
            $this->Error = ["Cadastro realizado com sucesso!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    public function ExeDelete($PostId) {
        $this->Post = (int) $PostId;

        $ReadPost = new Read;
        $ReadPost->ExeRead(self::Entity, "WHERE post_id = :post", "post={$this->Post}");

        if (!$ReadPost->getResult()):
            $this->Error = ["O post que você tentou deletar não existe no sistema!", WS_ERROR];
            $this->Result = false;
        else:
            $PostDelete = $ReadPost->getResult()[0];
            if (file_exists('../uploads/' . $PostDelete->post_cover) && !is_dir('../uploads/' . $PostDelete->post_cover)):
                unlink('../uploads/' . $PostDelete->post_cover);
            endif;
            if (file_exists('../uploads/' . $PostDelete->post_video) && !is_dir('../uploads/' . $PostDelete->post_video)):
                unlink('../uploads/' . $PostDelete->post_video);
            endif;

            $readGallery = new Read;
            $readGallery->ExeRead("ws_posts_gallery", "WHERE post_id = :id", "id={$this->Post}");
            if ($readGallery->getResult()):
                foreach ($readGallery->getResult() as $gbdel):
                    if (file_exists('../uploads/' . $gbdel->gallery_image) && !is_dir('../uploads/' . $gbdel->gallery_image)):
                        unlink('../uploads/' . $gbdel->gallery_image);
                    endif;
                endforeach;
            endif;

            $deleta = new Delete;
            $deleta->ExeDelete("ws_posts_gallery", "WHERE post_id = :gbpost", "gbpost={$this->Post}");
            $deleta->ExeDelete(self::Entity, "WHERE post_id = :postid", "postid={$this->Post}");

            $this->Error = ["O post <b>{$PostDelete->post_title}</b> foi removido com sucesso do sistema!", WS_ACCEPT];
            $this->Result = true;

        endif;
    }

    /**
     * <b>Ativa/Inativa Post:</b> Informe o ID do post e o status e um status sendo 1 para ativo e 0 para
     * rascunho. Esse méto ativa e inativa os posts!
     * @param INT $PostId = Id do post
     * @param STRING $PostStatus = 1 para ativo, 0 para inativo
     */
    public function ExeStatus($PostId, $PostStatus) {
        $this->Post = (int) $PostId;
        $this->Data['post_status'] = (string) $PostStatus;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE post_id = :id", "id={$this->Post}");
    }

    /**
     * <b>Enviar Galeria:</b> Envelope um $_FILES de um input multiple e envie junto a um postID para executar
     * o upload e o cadastro de galerias do artigo!
     * @param ARRAY $Files = Envie um $_FILES multiple
     * @param INT $PostId = Informe o ID do post
     */
    public function gbSend(array $Images, $PostId, $GalleryId = 0) {
        global $pt, $db;
        $this->Post = (int) $PostId;
        $this->Data = $Images;
        $tamanhoL = null;
        if ($GalleryId == 1) {
            $GalleryId = 1;
            $tamanhoL = 1600;
        }
        $ImageName = new Read;
        $ImageName->ExeRead(self::Entity, "WHERE post_id = :id", "id={$this->Post}");

        if (!$ImageName->getResult()):
            $this->Error = ["Erro ao enviar galeria. O índice {$this->Post} não foi encontrado no banco!", WS_ERROR];
            $this->Result = false;
        else:
            $ImageName = $ImageName->getResult()[0]->post_name;

            $gbFiles = array();
            $gbCount = count($this->Data['tmp_name']);
            $gbKeys = array_keys($this->Data);

            for ($gb = 0; $gb < $gbCount; $gb++):
                foreach ($gbKeys as $Keys):
                    $gbFiles[$gb][$Keys] = $this->Data[$Keys][$gb];
                endforeach;
            endfor;

            $gbSend = new Upload;
            $gbSendGallery = new Upload;
            $i = 0;
            $u = 0;

            foreach ($gbFiles as $gbUpload):
                $i++;

                if (!empty($gbUpload['type']) && $gbUpload['type'] == 'application/msword' ||
                        $gbUpload['type'] == 'application/pdf' ||
                        $gbUpload['type'] == 'application/x-compressed' ||
                        $gbUpload['type'] == 'application/x-zip-compressed' ||
                        $gbUpload['type'] == 'application/zip' ||
                        $gbUpload['type'] == 'multipart/x-zip' ||
                        $gbUpload['type'] == 'application/rar' ||
                        $gbUpload['type'] == 'multipart/x-rar' ||
                        $gbUpload['type'] == 'application/x-7z-compressed' ||
                        $gbUpload['type'] == 'application/x-rar-compressed' ||
                        $gbUpload['type'] == 'application/octet-stream' ||
                        $gbUpload['type'] == 'image/jpg' ||
                        $gbUpload['type'] == 'image/gif' ||
                        $gbUpload['type'] == 'image/png' ||
                        $gbUpload['type'] == 'image/jpeg' ||
                        $gbUpload['type'] == 'application/vnd.ms-excel.sheet.macroEnabled.12' ||
                        $gbUpload['type'] == 'image/pjpeg' ||
                        $gbUpload['type'] == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' ||
                        $gbUpload['type'] == 'application/csv' ||
                        $gbUpload['type'] == 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' ||
                        $gbUpload['type'] == 'application/vnd.ms-excel' ||
                        $gbUpload['type'] == 'application/vnd.ms-excel.sheet.binary.macroEnabled.12' ||
                        $gbUpload['type'] == 'application/vnd.ms-word.document.macroEnabled.12' ||
                        $gbUpload['type'] == 'application/vnd.openxmlformats-officedocument.presentationml.slideshow' ||
                        $gbUpload['type'] == 'application/vnd.ms-powerpoint' ||
                        $gbUpload['type'] == 'application/pkcs12' ||
                        $gbUpload['type'] == 'application/vnd.mspowerpoint' ||
                        $gbUpload['type'] == 'application/xhtml+xml' ||
                        $gbUpload['type'] == 'application/xml') {
                    $ImgName = "{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'] . '-' . (substr(md5(time() + $i), 0, 8));

                    $gbSend->File($gbUpload, $ImgName, 'files');

                    if ($gbSend->getResult()):
                        $gbImage = 'uploads/' . $gbSend->getResult();
                        $gbCreate = ['post_id' => $this->Post, "type" => $gbUpload['type'], "legenda" => "{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'], "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s')];
                        if (isset($_SESSION['userloginAdmin'])) {
                            $gbCreate = ['post_id' => $this->Post, 'assinante_id' => $_SESSION['userloginAdmin']->user_id, "type" => $gbUpload['type'], "legenda" => "{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'], "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s')];
                        }

                        $insertGb = new Create;
                        $insertGb->ExeCreate("ws_posts_gallery", $gbCreate);
                        $u++;
                    endif;
                } else {
                    $ImgName = "{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'] . '-' . (substr(md5(time() + $i), 0, 8));
                    $ImgNameCapa = "Capa-{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'] . '-' . (substr(md5(time() + $i), 0, 8));

                    $gbSend->Image($gbUpload, $ImgName, $tamanhoL, 'gallery');
                    $gbSendGallery->Image($gbUpload, $ImgNameCapa, $tamanhoL, 'gallery_capa');

                    if ($gbSend->getResult()):
                        $gbImage = 'uploads/' . $gbSend->getResult();
                        $gbImageGallery = 'uploads/' . $gbSendGallery->getResult();
                        $gbCreate = ['post_id' => $this->Post, "type" => $gbUpload['type'], "legenda" => "{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'], "gallery_type" => $GalleryId, "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s'), 'gallery_image_capa' => $gbImageGallery];
                        if (isset($_SESSION['userloginAdmin'])) {
                            $gbCreate = ['post_id' => $this->Post, 'assinante_id' => $_SESSION['userloginAdmin']->user_id, "type" => $gbUpload['type'], "legenda" => "{$ImageName}-gb-{$this->Post}-" . '-' . $gbUpload['name'], "gallery_type" => $GalleryId, "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s'), 'gallery_image_capa' => $gbImageGallery];
                        }
                        $insertGb = new Create;
                        $insertGb->ExeCreate("ws_posts_gallery", $gbCreate);
                        $u++;
                    endif;
                }

            endforeach;

            if ($u > 1):
                $this->Error = ["Galeria Atualizada: Foram enviadas {$u} imagens para galeria deste post!", WS_ACCEPT];
                $this->Result = true;
            endif;
        endif;
    }

    public function gbSendMidia(array $Images, $PostId, $GalleryId = 0) {
        global $pt, $db;
        $this->Post = (int) $PostId;
        $this->Data = $Images;
        $tamanhoL = null;
        if ($GalleryId == 1) {
            $GalleryId = 1;
            $tamanhoL = 1600;
        }
        $ImageName = new Read;
        $ImageName->ExeRead(self::Entity, "WHERE post_id = :id", "id={$this->Post}");

        if (!$ImageName->getResult()):
            $this->Error = ["Erro ao enviar galeria. O índice {$this->Post} não foi encontrado no banco!", WS_ERROR];
            $this->Result = false;
        else:
            $ImageName = $ImageName->getResult()[0]->post_name;

            $gbFiles = array();
            $gbCount = count($this->Data['tmp_name']);
            $gbKeys = array_keys($this->Data);

            for ($gb = 0; $gb < $gbCount; $gb++):
                foreach ($gbKeys as $Keys):
                    $gbFiles[$gb][$Keys] = $this->Data[$Keys][$gb];
                endforeach;
            endfor;

            $gbSend = new Upload;
            $gbSendGallery = new Upload;
            $i = 0;
            $u = 0;

            foreach ($gbFiles as $gbUpload):
                $i++;

                if (isset($gbUpload['type']) && $gbUpload['type'] == 'application/pdf') {
                    $ImgName = "{$ImageName}-gb-{$this->Post}-" . (substr(md5(time() + $i), 0, 8));

                    $gbSend->File($gbUpload, $ImgName, 'files');
                    if ($gbSend->getResult()):
                        $gbImage = 'uploads/' . $gbSend->getResult();
                        $gbCreate = ['post_id' => $this->Post, "type" => $gbUpload['type'], "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s')];
                        $insertGb = new Create;
                        $insertGb->ExeCreate("ws_posts_gallery", $gbCreate);
                        $u++;
                    endif;
                } else {
                    $ImgName = "{$ImageName}-gb-{$this->Post}-" . (substr(md5(time() + $i), 0, 8));
                    $ImgNameCapa = "Capa-{$ImageName}-gb-{$this->Post}-" . (substr(md5(time() + $i), 0, 8));

                    $gbSend->Image($gbUpload, $ImgName, $tamanhoL, 'gallery');
                    $gbSendGallery->Image($gbUpload, $ImgNameCapa, $tamanhoL, 'gallery_capa');

                    if ($gbSend->getResult()):
                        $gbImage = 'uploads/' . $gbSend->getResult();
                        $gbImageGallery = 'uploads/' . $gbSendGallery->getResult();
                        $gbCreate = ['post_id' => $this->Post, "type" => $gbUpload['type'], "gallery_type" => $GalleryId, "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s'), 'gallery_image_capa' => $gbImageGallery];
                        $insertGb = new Create;
                        $insertGb->ExeCreate("ws_posts_gallery", $gbCreate);
                        $u++;
                    endif;
                }

            endforeach;

            if ($u > 1):
                $this->Error = ["Galeria Atualizada: Foram enviadas {$u} imagens para galeria deste post!", WS_ACCEPT];
                $this->Result = true;
            endif;
        endif;
    }

    public function gbSendFile(array $Images, $PostId) {
        $this->Post = (int) $PostId;
        $this->Data = $Images;

        $ImageName = new Read;
        $ImageName->ExeRead(self::Entity, "WHERE post_id = :id", "id={$this->Post}");

        if (!$ImageName->getResult()):
            $this->Error = ["Erro ao enviar galeria. O índice {$this->Post} não foi encontrado no banco!", WS_ERROR];
            $this->Result = false;
        else:
            $ImageName = $ImageName->getResult()[0]->post_name;

            $gbFiles = array();
            $gbCount = count($this->Data['tmp_name']);
            $gbKeys = array_keys($this->Data);

            for ($gb = 0; $gb < $gbCount; $gb++):
                foreach ($gbKeys as $Keys):
                    $gbFiles[$gb][$Keys] = $this->Data[$Keys][$gb];
                endforeach;
            endfor;

            $gbSend = new Upload;
            $i = 0;
            $u = 0;

            foreach ($gbFiles as $gbUpload):
                $i++;
                $ImgName = "{$ImageName}-gb-{$this->Post}-" . (substr(md5(time() + $i), 0, 8));
                $gbSend->File($gbUpload, $ImgName);

                if ($gbSend->getResult()):
                    $gbImage = $gbSend->getResult();
                    $gbCreate = ['post_id' => $this->Post, "gallery_image" => $gbImage, "gallery_date" => date('Y-m-d H:i:s')];
                    $insertGb = new Create;
                    $insertGb->ExeCreate("ws_posts_gallery", $gbCreate);
                    $u++;
                endif;

            endforeach;

            if ($u > 1):
                $this->Error = ["Galeria Atualizada: Foram enviadas {$u} imagens para galeria deste post!", WS_ACCEPT];
                $this->Result = true;
            endif;
        endif;
    }

    /**
     * <b>Deletar Imagem da galeria:</b> Informe apenas o id da imagem na galeria para que esse método leia e remova
     * a imagem da pasta e delete o registro do banco!
     * @param INT $GbImageId = Id da imagem da galleria
     */
    public function gbRemove($GbImageId) {
        $this->Post = (int) $GbImageId;
        $readGb = new Read;
        $readGb->ExeRead("ws_posts_gallery", "WHERE gallery_id = :gb", "gb={$this->Post}");
        if ($readGb->getResult()):

            $Imagem = '../uploads/' . $readGb->getResult()[0]->gallery_image;

            if (file_exists($Imagem) && !is_dir($Imagem)):
                unlink($Imagem);
            endif;

            $Deleta = new Delete;
            $Deleta->ExeDelete("ws_posts_gallery", "WHERE gallery_id = :id", "id={$this->Post}");
            if ($Deleta->getResult()):
                $this->Error = ["A imagem foi removida com sucesso da galeria!", WS_ACCEPT];
                $this->Result = true;
            endif;

        endif;
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna ID do registro se o cadastro for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = InsertID or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    private function setData() {
        $Cover = $this->Data['post_cover'];
        $Content = $this->Data['post_content'];

        unset($this->Data['post_cover'], $this->Data['post_content']);

        $Check = new Check();
        $this->Data['post_name'] = $Check->Name($this->Data['post_title']);
        $this->Data['post_date'] = $Check->Data($this->Data['post_date']);
        $this->Data['post_cover'] = $Cover;

        $this->Data['post_content'] = $Content;
    }

    private function setName() {
        $Where = (isset($this->Post) ? "post_id != {$this->Post} AND" : '');
        $readName = new Read;
        $readName->ExeRead(self::Entity, "WHERE {$Where} post_title = :t", "t={$this->Data['post_title']}");
        if ($readName->getResult()):
            $this->Data['post_name'] = $this->Data['post_name'] . '-' . $readName->getRowCount() . '_' . time();
        endif;
    }

    private function Create() {

        $cadastra = new Create;
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()):
            $this->Error = ["O post {$this->Data['post_title']} foi cadastrado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    private function Update() {

        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE post_id = :id", "id={$this->Post}");
        if ($Update->getResult()):
            $this->Error = ["O post <b>{$this->Data['post_title']}</b> foi atualizado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    public static function CadastraCategoriaTag($param, $id, $string) {
        $opcao = $param;
        $cad['post_id'] = $id;
        $cad['type'] = $string;
        $contar = count($opcao);
        for ($i = 0; $i < $contar; $i++):
            $cad['category_id'] = $opcao[$i];
            $read = new Read;
            $read->ExeRead("ws_category_post", "where post_id = :post and category_id = :catid", "post={$id}&catid={$cad['category_id']}");
            if ($read->getResult()):
                $update = new Update;
                $update->ExeUpdate("ws_category_post", $cad, "where post_id = :post and category_id = :catid", "post={$id}&catid={$cad['category_id']}");
            else:
                $create = new Create;
                $create->ExeCreate("ws_category_post", $cad);
            endif;
        endfor;
    }

    static public function ListaPacotes() {
        $type = 'planos';
        $read = new Read;
        $read->ExeRead(self::Entity, "where post_type = :type and post_status = 1", "type={$type}");
        if ($read->getResult()):
            return $read->getResult();
        endif;
    }

    static public function ListarProdutos($stringType = null, $limit = null) {
        $limit = ($limit == null) ? 4 : "limit $limit";

        if ($stringType == null):
            $where = "where post_status = true and post_type = :type order by post_id desc $limit";
            $parse = "type=produto";
        else:
            $condicoes = "and post_{$stringType} = :{$stringType}";
            $where = "where post_status = true and post_type = :type {$condicoes} order by post_id desc $limit";
            $parse = "type=produto&{$stringType}=sim";
        endif;

        $read = new Read;
        $read->ExeRead(self::Entity, "{$where}", "{$parse}");
        if ($read->getResult()):
            return $read->getResult();
        endif;
    }

    static public function ListarProdutosNovos($stringType = null, $limit = null, $offset = null) {
        $limit = ($limit == null) ? 4 : "limit $limit OFFSET $offset";

        if ($stringType == null):
            $where = "where post_status = true and post_type = :type order by post_id desc $limit";
            $parse = "type=produto";
        else:
            $condicoes = "and post_{$stringType} = :{$stringType}";
            $where = "where post_status = true and post_type = :type {$condicoes} order by post_id desc $limit";
            $parse = "type=produto&{$stringType}=sim";
        endif;

        $read = new Read;
        $read->ExeRead(self::Entity, "{$where}", "{$parse}");
        if ($read->getResult()):
            return $read->getResult();
        endif;
    }

    static public function Img($pasta = null, $urlImg = null, $width = null, $height = null, $param = null, $title = null) {
        if (file_exists(DOCUMENT_ROOT . DIRECTORY_SEPARATOR . $pasta . DIRECTORY_SEPARATOR . $urlImg)):
            $imagem = "<img title='" . $title . "' alt='" . $title . "' src='" . BASE . "/tim.php?src=" . $pasta . "/" . $urlImg . "&h=" . $height . "&w=" . $width . "&zc=1' " . $param . " class='img-responsive' alt=''>";
        else:
            $imagem = "<img src='" . BASE . "/" . $pasta . "/images.png' " . $param . " class='img-responsive' alt=''>";
        endif;
        return $imagem;
    }

    static public function ThumbjQzoom($pasta = null, $urlImg = null, $width = null, $height = null, $param = null) {
        if (file_exists(DOCUMENT_ROOT . DIRECTORY_SEPARATOR . $pasta . DIRECTORY_SEPARATOR . $urlImg)):
            $imagem = "data-thumb='" . BASE . "/tim.php?src=" . $pasta . "/" . $urlImg . "&h=" . $height . "&w=" . $width . "&zc=1' " . $param;
        else:
            $imagem = "data-thumb='" . BASE . "/" . $pasta . "/images.png' " . $param;
        endif;
        return $imagem;
    }

    static public function Link($pasta = null, $url = null) {
        $link = BASE . "/" . $pasta . "/" . $url;
        return $link;
    }

    static public function Botao($nome, $id = null) {
        return '<button type="submit" name="add" data-text="' . $nome . '" class="btn btn-inverse btn-block"><i class= "fa fa-shopping-cart"></i> ' . $nome . '</button>'
                . '<img src="' . INCLUDE_PATH . '/images/ajax-loader.gif" class="load" width="40" style="display:none;"/>';
    }

    static public function produtoId($id = false) {
        $read = new Read;
        $read->ExeRead(self::Entity, "where post_id = :id", "id={$id}");
        if ($read->getRowCount() == 1):
            return $read->getResult()[0];
        else:
            return false;
        endif;
    }

    static public function getCart() {
        $jsonCart = [];
        $jsonCart['totalCarrinho'] = 0;
        $jsonCart['count'] = 0;

        if (isset($_SESSION['carrinho']) AND!empty($_SESSION['carrinho'])):

            $jsonCart['count'] = count($_SESSION['carrinho']);
            $Total = 0;

            foreach ($_SESSION['carrinho'] as $key => $value):
                $produto_id = $value['post_id'];
                $DadosProduto = AdminPost::produtoId($produto_id);

                $jsonCart['Dados'][] = [
                    'id' => $key,
                    'idProduto' => $DadosProduto->post_id,
                    'nome' => $DadosProduto->post_title,
                    'img' => $DadosProduto->post_cover,
                    'preco' => $DadosProduto->post_price,
                    'qtdminimo' => $DadosProduto->post_qtd_minimo,
                    'qtdmaximo' => $DadosProduto->post_estoque,
                    'url' => BASE . '/produto/' . $DadosProduto->post_name,
                    'quantidade' => $value['qtd'],
                    'qtdCores' => $value['qtdCores'],
                    'obs' => $value['obs'],
                    'img_logo' => $value['img_logo'],
                    'subtotal' => number_format($DadosProduto->post_price * $value['qtd'], 2, ",", "."),
                    'valor' => number_format($DadosProduto->post_price, 2, ",", ".")
                ];

                $Total += $DadosProduto->post_price * $value['qtd'];
                $jsonCart['totalCarrinho'] = number_format($Total, 2, ",", ".");

            endforeach;

        endif;
        return json_encode($jsonCart);
    }

    static public function getProduto($PostId) {
        $PostId = (int) $PostId;
        $read = new Read;
        $read->ExeRead(self::Entity, "where post_id = :id", "id={$PostId}");
        if ($read->getResult()):
            return $read->getResult()[0];
        endif;
    }

    static public function LoopCarrinho($PostId) {
        $PostId = (int) $PostId;
        $read = new Read;
        $read->ExeRead(self::Entity, "where post_id = :id", "id={$PostId}");
        if ($read->getResult()):
            return $read->getResult()[0];
        endif;
    }

}
