<?php

/**
 * AdminPost.class [ MODEL ADMIN ]
 * Respnsável por gerenciar os posts no Admin do sistema!
 * 
 * @copyright (c) 2014, Alisson MAciel
 */
class AdminGaleria {

    private $Data;
    private $Post;
    private $Error;
    private $Result;
    private $Type;

    //Nome da tabela no banco de dados
    const Entity = 'ws_posts_gallery';

    public function PostType($Type) {
        $this->Type = (string) $Type;
    }

    /**
     * <b>Cadastrar o Post:</b> Envelope os dados do post em um array atribuitivo e execute esse método
     * para cadastrar o post. Envia a capa automaticamente!
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;
//$this->setData();
        if ($this->Data['gallery_image']):
            $uplaod = new Upload;
            $uplaod->Image($this->Data['gallery_image'], $this->Data['gallery_image']['name']);
        endif;

        if (isset($uplaod) && $uplaod->getResult()):
            $this->Data['gallery_image'] = $uplaod->getResult();
            $this->Create();
        else:
            $this->Data['gallery_image'] = null;
            $this->Create();
        endif;
        
        
    }

    /**
     * <b>Atualizar Post:</b> Envelope os dados em uma array atribuitivo e informe o id de um 
     * post para atualiza-lo na tabela!
     * @param INT $PostId = Id do post
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($PostId, array $Data) {
        $this->Post = (int) $PostId;
        $this->Data = $Data;
//$this->setData();
        if (is_array($this->Data['gallery_image'])):
            $readCapa = new Read;
            $readCapa->ExeRead(self::Entity, "WHERE gallery_id = :post", "post={$this->Post}");
            $capa = '../uploads/' . $readCapa->getResult()[0]->post_cover;
            if (file_exists($capa) && !is_dir($capa)):
                unlink($capa);
            endif;

            $uploadCapa = new Upload;
            $uploadCapa->Image($this->Data['gallery_image'], $this->Data['gallery_image']['name']);
        endif;

        if (isset($uploadCapa) && $uploadCapa->getResult()):
            $this->Data['gallery_image'] = $uploadCapa->getResult();
            $this->Update();
        else:
            unset($this->Data['gallery_image']);
            $this->Update();
        endif;
        
        
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna ID do registro se o cadastro for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = InsertID or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */
    private function setData() {
        $Check = new Check();
        $this->Data['legenda'] = $Check->Name($this->Data['legenda']);
        
    }

    //Cadastra o post no banco!
    private function Create() {
        $cadastra = new Create;
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()):
           // $this->Error = ["O post {$this->Data['post_title']} foi cadastrado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    //Atualiza o post no banco!
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE gallery_id = :id", "id={$this->Post}");
        if ($Update->getResult()):
           // $this->Error = ["O post <b>{$this->Data['post_title']}</b> foi atualizado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
