<?php

/**
 * gMaps Class
 *
 * Pega as informações de latitude, longitude e zoom de um endereço usando a API do Google Maps
 *
 * @author Thiago Belem <contato@thiagobelem.net>
 */
class gMaps {

    private $mapsKey;

    function __construct($key = null) {
        if (!is_null($key)) {
            $this->mapsKey = $key;
        }
    }

    function carregaUrl($url) {
        if (function_exists('curl_init')) {
            $cURL = curl_init($url);
            curl_setopt($cURL, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($cURL, CURLOPT_FOLLOWLOCATION, true);
            $resultado = curl_exec($cURL);
            curl_close($cURL);
        } else {
            $resultado = file_get_contents($url);
        }
        if (!$resultado) {
            trigger_error('Não foi possível carregar o endereço: <strong>' . $url . '</strong>');
        } else {
            return $resultado;
        }
    }

    function geoLocal($endereco) {
        $url = "https://maps.googleapis.com/maps/api/geocode/json?key={$this->mapsKey}&address=" . urlencode($endereco);
        $data = json_decode($this->carregaUrl($url));

        if ($data->status === 'OK') {
            return $data->results[0]->geometry->location;
        } else {
            return false;
        }
    }

    function getLatLong($address, $region = false) {
        $address = str_replace(" ", "+", $address);
        if ($region == false) {
//            $json = file_get_contents("https://maps.google.com/maps/api/geocode/json?address=".urlencode($address)."&sensor=false");
            $json = file_get_contents("https://maps.googleapis.com/maps/api/directions/json?origin=Disneyland&destination=".urlencode($address)."&key={$this->mapsKey}");
        } else {
            $json = file_get_contents("https://maps.google.com/maps/api/geocode/json?key={$this->mapsKey}&address=$address&sensor=false&region=$region");
        }
        $json = json_decode($json);
echo '<pre>';
var_dump($json);
echo '</pre>';
        $lat = $json->{'results'}[0]->{'geometry'}->{'location'}->{'lat'};
        $long = $json->{'results'}[0]->{'geometry'}->{'location'}->{'lng'};

        return array('latitude' => $lat, 'longitude' => $long);
    }

}
