<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SupportEmail
 *
 * @author aliss
 */
use PHPMailer;
use Exception;
use stdClass;

class SupportEmail {

    /** @var PHPMailer */
    private $mail;

    /**
     *
     * @var stdClass /
     */
    private $data;

    /** @
     *
     * @var Exception /
     */
    private $error;

    public function __construct() {
        $this->mail = new PHPMailer(true);
        $this->data = new stdClass();

        $this->mail->isSMTP();
        $this->mail->isHTML();
        $this->mail->setLanguage('br');
        $this->mail->SMTPAuth = true;
        $this->mail->SMTPSecure = MAILSECURE;
        $this->mail->CharSet = 'utf-8';

        $this->mail->SMTPDebug = 2;

        $this->mail->Host = MAILHOST;
        $this->mail->Username = MAILUSERNAME;
        $this->mail->Password = MAILPASS;
        $this->mail->Port = MAILPORT;
    }

    public function add(string $subject, string $body, string $recipient_name, string $recipient_email): Email {
        $this->data->subject = $subject;
        $this->data->body = $body;
        $this->data->recipient_name = $recipient_name;
        $this->data->recipient_email = $recipient_email;
        return $this;
    }

    public function attach(string $filepath, string $filename): Email {
        $this->data->attach[$filepath] = $filename;
    }

    public function send(string $from_name = SITENAME, string $from_email = MAILUSER): bool {
        try {
            $this->mail->Subject = $this->data->subject;
            $this->mail->msgHTML($this->data->body);
            $this->mail->addAddress($this->data->recipient_email, $this->data->recipient_name);
            $this->mail->setFrom($from_email, $from_name);

            if (!empty($this->data->attach)) {
                foreach ($this->data->attach as $path => $name) {
                    $this->mail->addAttachment($path, $name);
                }
            }

            $this->mail->send();
            return true;
        } catch (Exception $exception) {
            $this->error = $exception;
            return false;
        }
    }

    public function error(): ?Exception {
        return $this->error;
    }

}
