<?php

/**
 * Link [ MODEL ]
 * Classe responsável por organizar o SEO do sistema e realizar a navegação!
 * 
* @copyright (c) 2015, Alisson Maciel AGÊNCIA DIGITAL WEB LAB
 */
class LinkAdmin {

    private $File;
    private $Link;

    /** DATA */
    private $Local;
    private $Patch;
    private $Tags;
    private $Data;

    /** @var Seo */
    private $Seo;
    
    function __construct() {
        $this->Local = strip_tags(trim(filter_input(INPUT_GET, 'url', FILTER_DEFAULT)));
        $this->Local = ($this->Local ? $this->Local : 'index');
        $this->Local = explode('/', $this->Local);
        $this->File = (isset($this->Local[0]) ? $this->Local[0] : 'index');
        $this->Link = (isset($this->Local[1]) ? $this->Local[1] : null);
        //$this->Seo = new Seo($this->File, $this->Link);
    }

    public function getTagsAdmin() {
        $this->Tags = $this->Seo->getTagsAdmin();
        echo $this->Tags;
    }

    public function getDataAdmin() {
        $this->Data = $this->Seo->getDataAdmin();
        return $this->Data;
    }

    public function getLocalAdmin() {
        return $this->Local;
    }

    public function getPatchAdmin() {
        $this->setPatchAdmin();
        return $this->Patch;
    }

    //PRIVATES
    private function setPatchAdmin() {
        if (file_exists(PATH.'/views' . DIRECTORY_SEPARATOR . $this->File . '.php')):
            $this->Patch = PATH.'/views' . DIRECTORY_SEPARATOR . $this->File . '.php';
        elseif (file_exists(PATH.'/views' . DIRECTORY_SEPARATOR . $this->File . DIRECTORY_SEPARATOR . $this->Link . '.php')):
            $this->Patch = PATH.'/views' . DIRECTORY_SEPARATOR . $this->File . DIRECTORY_SEPARATOR . $this->Link . '.php';
        else:
            $this->Patch = PATH.'/views' . DIRECTORY_SEPARATOR . '404.php';
        endif;
    }

}
