<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of APIPainelSocial
 *
 * @author WEBLAB
 */
class APIPainelSocial {

    private $API_URL = '';
    private $API_TOKEN = '';
    private $action;

    function __construct($API_URL = null, $API_TOKEN = null, $action = null) {
        $this->API_URL = $API_URL;
        $this->API_TOKEN = $API_TOKEN;
        $this->action = $action;
    }

    public function order($data) { // add order
        $post = array_merge([
            'token' => $this->API_TOKEN,
            'action' => $this->action
                ], $data);

        return json_decode($this->connect($post));
    }

    public function status($order_id) { // get order status
        return json_decode($this->connect([
                    'token' => $this->API_TOKEN,
                    'action' => $this->action,
                    'id' => $order_id
        ]));
    }

    public function balance() { // get balance
        return json_decode($this->connect([
                    'token' => $this->API_TOKEN,
                    'action' => 'balance',
        ]));
    }

    public function packages() { // get packages list
        return json_decode($this->connect([
                    'token' => $this->API_TOKEN,
                    'action' => 'packages',
        ]));
    }

    private function connect($post) {
        $_post = Array();
        foreach ($post as $name => $value) {
            $_post[$name] = urlencode($value);
        }

        $ch = curl_init($this->API_URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        $result = curl_exec($ch);
        if (curl_errno($ch) != 0 && empty($result)) {
            $result = false;
        }
        curl_close($ch);
        return $result;
    }


}
