<?php
$page = (!empty($input_get['page-id'])) ? $input_get['page-id'] : 1;
$filter_keyword = (!empty($input_get['query'])) ? ($input_get['query']) : '';
$filter_type = '';
$db->pageLimit = 20;
if (empty($linkto[3])) {
    $index = 'index';
} else {
    $index = $linkto[3];
}
if (!empty($filter_keyword)) {
    $sql = " {$filter_type} (customer_fullname LIKE '%$filter_keyword%' OR gateway LIKE '%$filter_keyword%' OR customer_email LIKE '%$filter_keyword%' OR customer_cpf LIKE '%$filter_keyword%' OR referencia LIKE '%$filter_keyword%') ";
    $faturas = $db->orderBy('status', 'asc')->where('code_assinatura', $linkto[4])->where('type','assinatura')->get("ws_faturas", $page);
} else {
    $faturas = $db->objectbuilder()->orderBy('id', 'asc')->where('code_assinatura', $linkto[4])->where('type','assinatura')->paginate('ws_faturas', $page);
}
$count = count($db->where('type','assinatura')->get('ws_faturas'));
if (($page > $db->totalPages) && !empty($input_get['page-id'])) {
    header("Location: " . BASE . $_SERVER['REQUEST_URI']);
    exit();
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section id="basic-form-layouts">
            <!-- Main content -->
            <div class="row">
                <!-- right column -->
                <div class="col-md-12">

                    <form action='<?= ADMIN; ?>/<?= $linkto[2]; ?>/index' method='get'>
                        <div class="col-lg-6 pull-right">
                            <a class="btn btn-info" href="<?= ADMIN; ?>/<?= $linkto[2]; ?>/inserir"><i class='fa fa-plus-circle'></i> Adicionar</a>
                        </div>
                        <div class="col-lg-6 pull-right">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Pesquisar por nome, e-mail, cpf, referência, gateway e etc" name='query' id='query'>
                                <span class="input-group-btn">
                                    <button class="btn btn-info" type="submit"><i class='fa fa-search'></i></button>
                                </span>
                            </div><!-- /input-group -->
                        </div><!-- /.col-lg-6 -->

                    </form>

                </div>
            </div>
            <div class="row">
                <!-- right column -->
                <!-- right column -->
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Listar faturas</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body table-responsive">
                                <table class="table text-center">
                                    <thead>
                                        <tr>
                                    <th>#</th>                                    
                                    <th>Valor</th>                                    
                                    <th>Data do pagamento</th>                                    
                                    <th>Próximo pagamento</th>                                    
                                    <th>Status</th>                                    
                                </tr> 
                                    </thead>
                                    <tbody>
                                        <?php
                                if ($faturas) {
                                    foreach ($faturas as $key => $invoices) {
                                        ?>
                                        <tr>
                                            <td><?= $invoices->id; ?></td>
                                            <td>R$<?= $invoices->amount; ?></td>
                                            <td><?= date('d/m/Y H:i', strtotime($invoices->data_criacao)); ?></td>
                                            <td><?= date('d/m/Y', strtotime($invoices->proxima_cobranca)); ?></td>
                                            <td><?= $invoices->status; ?></td>
                                        </tr>
                                        <?php
                                    }
                                }
                                ?>                             
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="col-md-6 pull-left">
                        <?php echo "Total (" . $count . ") registros | Mostrando $page página(s) de " . $db->totalPages; ?>
                    </div>
                    <div class="col-md-6 pull-right">
                        <nav class="" aria-label="Page navigation mb-3">
                            <ul class="pagination justify-content-end">
                                <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=1" aria-label="Previous"><i class="fa fa-home"></i></a>
                                </li>
                                <?php if ($page > 1) { ?>
                                    <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($page - 1); ?>"><i class="fa fa-chevron-left"></i></a></li>
                                <?php } ?>
                                <?php
                                $nums = 0;
                                $nums_pages = ($page > 4) ? ($page - 4) : $page;
                                for ($i = $nums_pages; $i <= $db->totalPages; $i++) {
                                    if ($nums < 20) {
                                        ?>
                                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($i); ?>"><?php echo $i ?></a></li>
                                        <?php
                                    }
                                    $nums++;
                                }
                                ?>
                                <?php if ($db->totalPages > $page) { ?>
                                    <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($page + 1); ?>"><i class="fa fa-chevron-right"></i></a></li>
                                <?php } ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($db->totalPages); ?>" aria-label="Next"><i class="fa fa-forward"></i></a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
    </div>
    <!--/.col (right) -->
</div>
<!-- /.row -->
</section>
<!-- /.content -->
</div>
</div>
<div class="modal fade text-left" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel10" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content modal-col-red">
            <div class="modal-header bg-danger white">
                <h4 class="modal-title" id="myModalLabel10">DELETAR REGISTRO</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja remover esse registro?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger waves-effect delete-button" data-dismiss="modal" data-type="<?= $linkto[2]; ?>">DELETAR</button>
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">FECHAR</button>
            </div>
        </div>
    </div>
</div>