<!DOCTYPE html>
<html lang="pt-br" class="loading">
    <!-- BEGIN : Head-->
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
        <title><?= $pt->config->title; ?></title>
        <link rel="apple-touch-icon" sizes="60x60" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/ico/apple-icon-60.png">
        <link rel="apple-touch-icon" sizes="76x76" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/ico/apple-icon-76.png">
        <link rel="apple-touch-icon" sizes="120x120" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/ico/apple-icon-120.png">
        <link rel="apple-touch-icon" sizes="152x152" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/ico/apple-icon-152.png">
        <link rel="shortcut icon" type="image/x-icon" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/ico/favicon.ico">
        <link rel="shortcut icon" type="image/png" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/ico/favicon-32.png">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-touch-fullscreen" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="default">
        <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,500,700,900|Montserrat:300,400,500,600,700,800,900" rel="stylesheet">
        <!-- BEGIN VENDOR CSS-->
        <!-- font icons-->
        <link rel="stylesheet" type="text/css" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/fonts/feather/style.min.css?id=<?=time();?>">
        <link rel="stylesheet" type="text/css" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/fonts/simple-line-icons/style.css?id=<?=time();?>">
        <link rel="stylesheet" type="text/css" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/fonts/font-awesome/css/font-awesome.min.css?id=<?=time();?>">
        <link rel="stylesheet" type="text/css" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/css/perfect-scrollbar.min.css?id=<?=time();?>">
        <link rel="stylesheet" type="text/css" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/css/prism.min.css?id=<?=time();?>">
        <!-- END VENDOR CSS-->
        <!-- BEGIN APEX CSS-->
        <link rel="stylesheet" type="text/css" href="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/css/app.css?id=<?=time();?>">
        <!-- END APEX CSS-->
        <!-- BEGIN Page Level CSS-->
        <!-- END Page Level CSS-->
    </head>
    <!-- END : Head-->

    <!-- BEGIN : Body-->
    <body data-col="1-column" class=" 1-column  blank-page">
        <!-- ////////////////////////////////////////////////////////////////////////////-->
        <div class="wrapper">
            <div class="main-panel">
                <!-- BEGIN : Main Content-->
                <div class="main-content">
                    <div class="content-wrapper"><!--Login Page Starts-->
                        <section id="login"> 
                            <div class="container-fluid">
                                <div class="row full-height-vh m-0">
                                    <div class="col-md-12 d-flex align-items-center justify-content-center">
                                        <div class="card">
                                            <div class="card-content">
                                                <div class="card-body login-img">
                                                    <div class="row m-0">

                                                        <div class="col-lg-6 d-lg-block d-none py-2 text-center align-middle">
                                                            <img src="<?= BASE . '/' . $logomarcaAdmin; ?>" alt="" class="img-fluid mt-5" width="240" />
                                                            <p></p>
                                                            <h3>Plataforma de Gestão</h3>
                                                            <!--<img src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/img/gallery/login.png" alt="" class="img-fluid mt-5" width="400" height="230">-->
                                                        </div>
                                                        <div class="col-lg-6 col-md-12 bg-white px-4 pt-3">
                                                            <h4 class="mb-2 card-title">Login</h4>
                                                            <p class="card-text mb-3">
                                                                Bem-vindo de volta, por favor faça login em sua conta.
                                                            </p>
                                                            <form method="post" action="" id="form-login">
                                                                <input type="email" class="form-control email mb-3" name="email" placeholder="Infome o E-mail" value="<?= $email ?>">
                                                                <input type="password" class="form-control senha mb-1" name="senha" placeholder="Infome a Senha" value="<?= $senha ?>">
                                                                <div class="d-flex justify-content-between mt-2">
                                                                    <!--<div class="remember-me">
                                                                        <div class="custom-control custom-checkbox custom-control-inline mb-3">
                                                                            <input type="checkbox" id="customCheckboxInline1" name="lembrete" class="custom-control-input" value="SIM" <?= $checked ?>> 
                                                                            <label class="custom-control-label" for="customCheckboxInline1">
                                                                                Lembrar-me
                                                                            </label>
                                                                        </div>
                                                                    </div>-->
                                                                    <div class="forgot-password-option">
                                                                        <!--<a href="forgot-password-page.html" class="text-decoration-none text-primary">Forgot Password?</a>-->
                                                                    </div>
                                                                </div>
                                                                <div class="fg-actions d-flex justify-content-between">
                                                                    <div class="login-btn">
                                                                        <!--                                                                    <button class="btn btn-outline-primary">
                                                                                                                                                <a href="register-page.html" class="text-decoration-none">Register</a>
                                                                                                                                            </button>-->
                                                                    </div>
                                                                    <div class="recover-pass">
                                                                        <button type="submit" class="btn btn-primary login">Entrar</button>
                                                                        <!--                                                                    <button class="btn btn-primary">
                                                                                                                                                <a href="dashboard1.html" class="text-decoration-none text-white">Login</a>
                                                                                                                                            </button>-->
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <!--Login Page Ends-->

                    </div>
                </div>
                <!-- END : End Main Content-->
            </div>
        </div>
        <!-- ////////////////////////////////////////////////////////////////////////////-->

        <!-- BEGIN VENDOR JS-->
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/core/jquery-3.2.1.min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/core/popper.min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/core/bootstrap.min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/perfect-scrollbar.jquery.min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/prism.min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/jquery.matchHeight-min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/screenfull.min.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/vendors/js/pace/pace.min.js" type="text/javascript"></script>
        <!-- BEGIN VENDOR JS-->
        <!-- BEGIN PAGE VENDOR JS-->
        <!-- END PAGE VENDOR JS-->
        <!-- BEGIN APEX JS-->
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/js/app-sidebar.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/js/notification-sidebar.js" type="text/javascript"></script>
        <script src="<?= REQUIRE_PATH_ADMIN; ?>/app-assets/js/customizer.js" type="text/javascript"></script>
        <script>
            $(function () {
                $('.login').click(function (e) {
                    e.preventDefault();
                    var dados = 'action=login_admin&' + $('#form-login').serialize();
                    $.ajax({
                        url: '<?= MODULOS; ?>/index.php',
                        data: dados,
                        method: 'post',
                        dataType: 'json',
                        beforeSend: function () {
                            $('.login').attr('disabled', true).hide();
                        },
                        success: function (response) {
                            if (response.status == 200) {
                                location.href = "<?= ADMIN; ?>/index";
                            } else {
                                alert(response.msg);
                                location.reload();
                            }
                        }
                    });
                });
                /*$('input').iCheck({
                    checkboxClass: 'icheckbox_square-blue',
                    radioClass: 'iradio_square-blue',
                    increaseArea: '20%' // optional
                });*/
            });
        </script>
        <!-- END APEX JS-->
        <!-- BEGIN PAGE LEVEL JS-->
        <!-- END PAGE LEVEL JS-->
    </body>
    <!-- END : Body-->
</html>
<?php
$db->disconnect();
