var raiz = window.location.origin;
$(function () {
    var raiz = window.location.origin;
    var btn_reativar = $("#btn-reativar");
    var btn_suspender = $("#btn-suspender");
    var message = $("#message");

    btn_suspender.on('click', function (event) {
        event.preventDefault();

        var id_assinatura = $(this).attr('data-id');

        $.ajax({
            url: '/admin/modulos/responds.php',
            type: 'post',
            dataType: 'json',
            data: 'acao=suspende_ativa&id_assinatura=' + id_assinatura + '&status=SUSPENDED',
            beforeSend: function () {
                let mensagemAguarde = "<i class='fa fa-spinner fa-spin fa-1x fa-fw'></i>Aguarde enquanto atualizamos o status da assinatura !!!";
                message.html('<div class="alert alert-info" style="text-align:center;">' + mensagemAguarde + '</div><br />');
            },
            success: function (retorno) {

                if (retorno.error == true) {
                    message.html(showError(retorno))
                }

                if (retorno.status == 'ok') {
                    message.html("<div class='alert alert-warning' style='text-align:center;''><i class='fa fa-check' aria-hidden='true'></i> A assinatura foi suspensa, para reativar clique no botão para reativar conta.</div><br />");
                }

                setTimeout(function () {
                    location.reload();
                }, 3000);
            }
        });
    });

    btn_reativar.on('click', function (event) {
        event.preventDefault();

        var id_assinatura = $(this).attr('data-id');

        $.ajax({
            url: '/admin/modulos/responds.php',
            type: 'post',
            dataType: 'json',
            data: 'acao=suspende_ativa&id_assinatura=' + id_assinatura + '&status=ACTIVE',
            beforeSend: function () {
                let mensagemAguarde = "<i class='fa fa-spinner fa-spin fa-1x fa-fw'></i>Aguarde enquanto atualizamos o status da assinatura !!!";
                message.html('<div class="alert alert-info" style="text-align:center;">' + mensagemAguarde + '</div><br />');
            },
            success: function (retorno) {

                console.log(retorno);

                if (retorno.error == true) {
                    message.html(showError(retorno))
                }

                if (retorno.status == 'ok') {
                    message.html("<div class='alert alert-success 'style='text-align:center;''><i class='fa fa-check' aria-hidden='true'></i> A assinatura foi reativada com sucesso.</div><br />");
                }

                setTimeout(function () {
                    location.reload();
                }, 3000);
            }
        });
    });

    $('[data-toggle="tooltip"]').tooltip()

    $('#datepicker').datepicker({
        autoclose: true
    });
    $(".select2").select2();
    $(".valor").maskMoney({symbol: '',
        showSymbol: true, thousands: '', decimal: '.', symbolStay: true});
    $('.data_input').mask("99/99/9999 99:99");
    $('.cel').mask("(99) 99999-999?9");
    $('.tel').mask("(99) 9999-9999");
    $('.cep').mask("99999-999");

    $('.delete-content').on('click', function (event) {
        event.preventDefault();
        $('#delete-modal').attr('data-id', $(this).attr('data-id')).modal('show');
    });
    $('#theme_landingpage').on('change', function (event) {
        event.preventDefault();
        var valor = $(this).val();
        if (valor == 'on') {
            $('#landing_menu').show();
        } else {
            $('#landing_menu').hide();
        }
    });

    $('.delete-button').on('click', function (event) {
        event.preventDefault();

        var ajax_type = $(this).attr('data-type');
        var id = $('#delete-modal').attr('data-id');

        

        $.ajax({
            url: '/admin/modulos/delete.php',
            data: 'action=delete-' + ajax_type + '&id=' + id,
            type: 'post',
            dataType:'json',
            success: function (data) {
                if(data.status == 300){
                    alert(data.msg)
                }else{
                    $('#list-' + id).remove();
                }
            }
        });
    });

    $('#nao_alterar_capa').click(function () {
        $(this).hide();
        $('#alterar_capa').show();
        $('#post_cover').attr('disabled', true);
    });
    $('#alterar_capa').click(function () {
        $(this).hide();
        $('#nao_alterar_capa').show();
        $('#post_cover').attr('disabled', false);
    });
    $('#nao_alterar_capa_cat').click(function () {
        $(this).hide();
        $('#alterar_capa_cat').show();
        $('#category_img').attr('disabled', true);
    });
    $('#alterar_capa_cat').click(function () {
        $(this).hide();
        $('#nao_alterar_capa_cat').show();
        $('#category_img').attr('disabled', false);
    });

    $('.post_title').keyup(function () {
        var type = $('.post_type').val();
        var token = $('.post_token').val();
        $.ajax({
            url: '/admin/modulos/slug.php',
            data: 'title=' + $(this).val() + '&id=' + $(this).attr('data-input-id'),
            dataType: 'json',
            method: 'post',
            success: function (response) {
                if (response.status == 200) {
                    $('span.slug-text').text(response.slug+'_'+token)
                    $('.post_name').val(response.slug+'_'+token)
                    $('a.link_slug').attr('href', raiz + '/' + type + '/' + response.slug+'_'+token);
                }
            }
        });
    });
    /*$('.post_token').keyup(function () {
        var type = $('.post_type').val();
        var token = $('.post_token').val();
        $.ajax({
            url: '/admin/modulos/slug.php',
            data: 'title=' + $(this).val() + '&id=' + $(this).attr('data-input-id'),
            dataType: 'json',
            method: 'post',
            success: function (response) {
                if (response.status == 200) {
                    $('span.slug-text').text(response.slug+'_'+token)
                    $('.post_name').val(response.slug+'_'+token)
                    $('a.link_slug').attr('href', raiz + '/' + type + '/' + response.slug+'_'+token);
                }
            }
        });
    });*/
    $('.category_title,.category_names').keyup(function () {
        var type = $('.category_type').val();
        $.ajax({
            url: '/admin/modulos/slug.php',
            data: 'title=' + $(this).val() + '&id=' + $(this).attr('data-input-id'),
            dataType: 'json',
            method: 'post',
            success: function (response) {
                if (response.status == 200) {
                    $('span.slug-text').text(response.slug)
                    $('.category_names').val(response.slug)
                    $('.category_name').val(response.slug)
                    $('a.link_slug').attr('href', raiz + '/' + type + '/' + response.slug);
                }
            }
        });
    });

    $(".class_files").on("change", function () {
        var files = !!this.files ? this.files : [];
        if (!files.length || !window.FileReader)
            return;

        if (/^image/.test(files[0].type)) {
            var reader = new FileReader();
            reader.readAsDataURL(files[0]);
            reader.onload = function () {
                $("#imagem").attr('src', this.result);
            }
        }
    });
    $(".logo").on("change", function () {
        var files = !!this.files ? this.files : [];
        if (!files.length || !window.FileReader)
            return;

        if (/^image/.test(files[0].type)) {
            var reader = new FileReader();
            reader.readAsDataURL(files[0]);
            reader.onload = function () {
                $("#logo").attr('src', this.result);
            }
        }
    });
    $(".favicon").on("change", function () {
        var files = !!this.files ? this.files : [];
        if (!files.length || !window.FileReader)
            return;

        if (/^image/.test(files[0].type)) {
            var reader = new FileReader();
            reader.readAsDataURL(files[0]);
            reader.onload = function () {
                $("#favicon").attr('src', this.result);
            }
        }
    });
    $(".rodape").on("change", function () {
        var files = !!this.files ? this.files : [];
        if (!files.length || !window.FileReader)
            return;

        if (/^image/.test(files[0].type)) {
            var reader = new FileReader();
            reader.readAsDataURL(files[0]);
            reader.onload = function () {
                $("#rodape").attr('src', this.result);
            }
        }
    });
    $("#uploadForm").on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: '/admin/modulos/upload_gallery.php',
            data: new FormData(this),
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $('#uploadStatus').html('<img src="/admin/images/ajax-loading.gif"/>');
                $('.btn_upload_gallery').hide();
                $('.btn_upload_gallery').attr('disabled', true);
            },
            error: function () {
                $('#uploadStatus').html('<span style="color:#EA4335;">Falha ao tentar realizar o upload, tente novamente.<span>');
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
            },
            success: function (data) {
                $('#uploadForm')[0].reset();
                $('#uploadStatus').html('<span style="color:#28A74B;">Upload realizado com sucesso.<span>');
                $('.gallery').html(data);
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
            }
        });
    });
    $("#uploadFormTabelas").on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: '/admin/modulos/upload_gallery.php',
            data: new FormData(this),
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $('#uploadStatusTabelas').html('<img src="/admin/images/ajax-loading.gif"/>');
                $('.btn_upload_gallerytab').hide();
                $('.btn_upload_gallerytab').attr('disabled', true);
            },
            error: function () {
                $('#uploadStatusTabelas').html('<span style="color:#EA4335;">Falha ao tentar realizar o upload, tente novamente.<span>');
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
            },
            success: function (data) {
                $('#uploadFormTabelas')[0].reset();
                $('#uploadStatusTabelas').html('<span style="color:#28A74B;">Upload realizado com sucesso.<span>');
                $('.gallerytab').html(data);
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
            }
        });
    });

    $('.legenda').keyup(function (e) {
        var id = $(this).attr('data-legenda-gallery-id');
        var legenda = $(this).val();
        $.ajax({
            url: '/admin/modulos/post.php',
            method: 'post',
            dataType: 'json',
            data: 'action=post_update_legenda_gallery&id=' + id + '&legenda=' + legenda,
            beforeSend: function () {},
            success: function (response) {}
        });
    });
    $('.ordem').keyup(function (e) {
        var id = $(this).attr('data-ordem-gallery-id');
        var ordem = $(this).val();
        $.ajax({
            url: '/admin/modulos/post.php',
            method: 'post',
            dataType: 'json',
            data: 'action=post_update_ordem_gallery&id=' + id + '&ordem=' + ordem,
            beforeSend: function () {},
            success: function (response) {}
        });
    });
    $('.legendatab').keyup(function (e) {
        var id = $(this).attr('data-legenda-gallery-id-tab');
        var legenda = $(this).val();
        $.ajax({
            url: '/admin/modulos/post.php',
            method: 'post',
            dataType: 'json',
            data: 'action=post_update_legenda_gallery&id=' + id + '&legenda=' + legenda,
            beforeSend: function () {},
            success: function (response) {}
        });
    });
    $('.ordemtab').keyup(function (e) {
        var id = $(this).attr('data-ordem-gallery-id-tab');
        var ordem = $(this).val();
        $.ajax({
            url: '/admin/modulos/post.php',
            method: 'post',
            dataType: 'json',
            data: 'action=post_update_ordem_gallery&id=' + id + '&ordem=' + ordem,
            beforeSend: function () {},
            success: function (response) {}
        });
    });
    $("#gallery_image").change(function () {
        var fileLength = this.files.length;
        var match = ["image/jpeg", "image/png", 
            "image/jpg", "image/gif", 
            "text/csv", "application/csv",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.ms-excel",
            "application/vnd.ms-excel.sheet.binary.macroEnabled.12",
            "application/msword",
            "application/vnd.ms-word.document.macroEnabled.12",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
            "application/vnd.ms-powerpoint",
            "application/pdf","application/octet-stream", "application/pkcs12", "application/vnd.mspowerpoint", 
            "application/xhtml+xml", "application/xml",  "application/pdf"];
        var i;
        for (i = 0; i < fileLength; i++) {
            var file = this.files[i];
            var imagefile = file.type;
            if (!((imagefile == match[0]) || (imagefile == match[1]) || (imagefile == match[2]) || (imagefile == match[3]) || (imagefile == match[4])
                     || (imagefile == match[5])
                      || (imagefile == match[6])
                       || (imagefile == match[7])
                        || (imagefile == match[8])
                         || (imagefile == match[9])
                          || (imagefile == match[10])
                           || (imagefile == match[11])
                            || (imagefile == match[12]) 
                            || (imagefile == match[13])
                             || (imagefile == match[14])
                              || (imagefile == match[15])
                               || (imagefile == match[16])
                                || (imagefile == match[17]) 
                                || (imagefile == match[18])
                                 || (imagefile == match[19])
                                  || (imagefile == match[20])
                                   || (imagefile == match[21])
                                    || (imagefile == match[22]))) {
                alert('Please select a valid image file (JPEG/JPG/PNG/GIF/PDF).');
                $("#gallery_image").val('');
                return false;
            }
        }
        $('.btn_upload_gallery').show();
        $('.btn_upload_gallery').attr('disabled', false);
    });
    $("#gallery_image_tabelas").change(function () {
        var fileLength = this.files.length;
        var match = ["image/jpeg", "image/png", 
            "image/jpg", "image/gif", 
            "text/csv", "application/csv",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.ms-excel",
            "application/vnd.ms-excel.sheet.binary.macroEnabled.12",
            "application/msword",
            "application/vnd.ms-word.document.macroEnabled.12",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
            "application/vnd.ms-powerpoint",
            "application/pdf","application/octet-stream", "application/pkcs12", "application/vnd.mspowerpoint", 
            "application/xhtml+xml", "application/xml",  "application/pdf"];
        var i;
        for (i = 0; i < fileLength; i++) {
            var file = this.files[i];
            var imagefile = file.type;
            if (!((imagefile == match[0]) || (imagefile == match[1]) || (imagefile == match[2]) || (imagefile == match[3]) || (imagefile == match[4])
                     || (imagefile == match[5])
                      || (imagefile == match[6])
                       || (imagefile == match[7])
                        || (imagefile == match[8])
                         || (imagefile == match[9])
                          || (imagefile == match[10])
                           || (imagefile == match[11])
                            || (imagefile == match[12]) 
                            || (imagefile == match[13])
                             || (imagefile == match[14])
                              || (imagefile == match[15])
                               || (imagefile == match[16])
                                || (imagefile == match[17]) 
                                || (imagefile == match[18])
                                 || (imagefile == match[19])
                                  || (imagefile == match[20])
                                   || (imagefile == match[21])
                                    || (imagefile == match[22]))) {
                alert('Please select a valid image file (JPEG/JPG/PNG/GIF/PDF).');
                $("#gallery_image_tabelas").val('');
                return false;
            }
        }
        $('.btn_upload_gallerytab').show();
        $('.btn_upload_gallerytab').attr('disabled', false);
    });

    $(document).on('submit', 'form.form-post', function (e) {
        $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        //formdata.set('post_content', CKEDITOR.instances['post_content'].getData());
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
        });

        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_post').attr('disabled', false).text('Publicar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/' + data.type;/* + '/editar/' + data.id*/
                    }, 1000);
                } else {
                    alert(data.msg+' - post?');
                    $('.btn_post').attr('disabled', false).text('Publicar');
                }
            }
        }
        request.open('post', '/admin/modulos/post.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.form-cartao', function (e) {
        $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        //formdata.set('post_content', CKEDITOR.instances['post_content'].getData());
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
        });

        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_post').attr('disabled', false).text('Publicar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/' + data.type;/* + '/editar/' + data.id*/
                    }, 1000);
                } else {
                    alert(data.msg+' - post?');
                    $('.btn_post').attr('disabled', false).text('Publicar');
                }
            }
        }
        request.open('post', '/admin/modulos/cartao.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.form-grupo', function (e) {
        $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        //formdata.set('post_content', CKEDITOR.instances['post_content'].getData());
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
        });

        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_post').attr('disabled', false).text('Publicar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/' + data.type;/* + '/editar/' + data.id*/
                    }, 1000);
                } else {
                    alert(data.msg+' - grupo?');
                    $('.btn_post').attr('disabled', false).text('Publicar');
                }
            }
        }
        request.open('post', '/admin/modulos/grupo.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.form-cupom', function (e) {
        $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
        });

        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_post').attr('disabled', false).text('Adicionar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/' + data.type + '/editar/' + data.id
                    }, 1000);
                } else {
                    alert(data.msg);
                    $('.btn_post').attr('disabled', false).text('Adicionar');
                }
            }
        }
        request.open('post', '/admin/modulos/cupom.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.form-api', function (e) {
        $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
        });

        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_post').attr('disabled', false).text('Adicionar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.btn_post').attr('disabled', true).text('Aguarde um momento...');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/' + data.type + '/editar/' + data.id
                    }, 1000);
                } else {
                    alert(data.msg);
                    $('.btn_post').attr('disabled', false).text('Adicionar');
                }
            }
        }
        request.open('post', '/admin/modulos/api.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.form-category', function (e) {
        $('.btn_category').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_category').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
        });
        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_category').attr('disabled', false).text('Publicar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.btn_category').attr('disabled', true).text('Aguarde um momento...');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/' + data.type+'/index?type=' + data.tipo; /*+ '/editar/' + data.id + '/?type=' + data.tipo*/
                    }, 1000);
                } else {
                    alert(data.msg);
                    $('.btn_category').attr('disabled', false).text('Publicar');
                }
            }
        }
        request.open('post', '/admin/modulos/categoria.php');
        request.send(formdata);
    });
    $('#upload_system_type').change(function (event) {
        if ($(this).val() == 1) {
            $('#p_f_users_').removeClass('hidden');
            $('#all_users_').addClass('hidden');
        } else {
            $('#all_users_').removeClass('hidden');
            $('#p_f_users_').addClass('hidden');
        }
    });
    var api_views_settings = $('form.api_views-settings');
    api_views_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + api_views_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                api_views_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    api_views_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.api_views-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.api_views-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var api_curtidas_settings = $('form.api_curtidas-settings');
    api_curtidas_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + api_curtidas_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                api_curtidas_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    api_curtidas_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.api_curtidas-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.api_curtidas-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var api_curtidas_automaticas_settings = $('form.api_curtidas_automaticas-settings');
    api_curtidas_automaticas_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + api_curtidas_automaticas_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                api_curtidas_automaticas_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    api_curtidas_automaticas_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.api_curtidas_automaticas-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.api_curtidas_automaticas-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var api_seguidores_settings = $('form.api_seguidores-settings');
    api_seguidores_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + api_seguidores_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                api_seguidores_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    api_seguidores_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.api_seguidores-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.api_seguidores-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var user_settings = $('form.user-settings');
    user_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + user_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                user_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    user_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.user-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.user-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var uploads_settings = $('form.uploads-settings');
    uploads_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + uploads_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                uploads_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    uploads_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.uploads-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.uploads-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var ps_settings = $('form.payment-pagseguro-settings');
    ps_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + ps_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                ps_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    ps_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.payment-pagseguro-ettings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.payment-pagseguro-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var ps_settings_basico = $('form.payment-pagseguro-basico-settings');
    ps_settings_basico.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + ps_settings_basico.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                ps_settings_basico.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    ps_settings_basico.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.payment-pagseguro-basico-ettings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.payment-pagseguro-basico-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var settings_settings = $('form.settings-settings');
    settings_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + settings_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                settings_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    settings_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.settings-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.settings-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var settings_settings_paghiper = $('form.settings-settings-paghiper');
    settings_settings_paghiper.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + settings_settings_paghiper.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                settings_settings_paghiper.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    settings_settings_paghiper.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.paghiper-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.paghiper-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    
    
    var settings_settings_local = $('form.settings-settings-local');
    settings_settings_local.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + settings_settings_local.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                settings_settings_local.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    settings_settings_local.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.local-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.local-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var smtp_settings = $('form.smtp-settings');
    smtp_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + smtp_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                smtp_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    smtp_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.smtp-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.smtp-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    var social_settings = $('form.settings-settings-social');
    social_settings.submit(function (e) {
        e.preventDefault();
        $.ajax({
            url: '/admin/modulos/settings.php',
            data: 'action=save-settings&' + social_settings.serialize(),
            dataType: 'json',
            method: 'post',
            beforeSend: function () {
                social_settings.find('.waves-effect').text("Aguarde...").attr('disabled', true);
            },
            success: function (data) {
                if (data.status == 200) {
                    social_settings.find('.waves-effect').text('Salvar').attr('disabled', false);
                    $('.social-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        $('.social-settings-alert').empty().hide();
                    }, 2000);
                }
            }
        });
    });
    $(document).on('submit', 'form.logo-settings', function (e) {
        $('.btn_save_config_logo').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        //Receber os dados
        $form = $(this);
        var formdata = new FormData($form[0]);
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_save_config_logo').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Logo enviado com sucesso!');
        });
        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_save_config_logo').attr('disabled', false).text('Salvar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.logo-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/config/index';
                    }, 2000);
                } else {
                    $('.logo-settings-alert').html('<i class="fa fa-remove"></i> Erro ao tentar atualizar a logo.').show().removeClass('alert-success').addClass('alert-danger');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/config/index';
                    }, 2000);
                }
            }
        }
        request.open('post', '/admin/modulos/settings.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.favicon-settings', function (e) {
        $('.btn_save_config_favicon').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_save_config_favicon').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Favicon enviado com sucesso!');
        });
        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_save_config_favicon').attr('disabled', false).text('Salvar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.favicon-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/config/index';
                    }, 2000);
                } else {
                    $('.favicon-settings-alert').html('<i class="fa fa-remove"></i> Erro ao tentar atualizar o favicon.').show().removeClass('alert-success').addClass('alert-danger');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/config/index';
                    }, 2000);
                }
            }
        }
        request.open('post', '/admin/modulos/settings.php');
        request.send(formdata);
    });
    $(document).on('submit', 'form.rodape-settings', function (e) {
        $('.btn_save_config_rodape').attr('disabled', true).text('Aguarde um momento...');
        e.preventDefault();
        $form = $(this);
        var formdata = new FormData($form[0]);
        var request = new XMLHttpRequest();
        request.upload.addEventListener('progress', function (e) {
            $('.btn_save_config_rodape').attr('disabled', true).text('Aguarde um momento...');
            var percent = Math.round(e.loaded / e.total * 100);
            $form.find('.progress-bar').width(percent + '%').html(percent + '%');
        });
        request.addEventListener('load', function (e) {
            $form.find('.progress-bar').addClass('progress-bar-success').html('Favicon enviado com sucesso!');
        });

        request.onreadystatechange = function () {
            if (request.readyState == 1) {
                $('.btn_save_config_rodape').attr('disabled', false).text('Salvar');
            }
            if (request.readyState == 4) {
                var data = JSON.parse(request.responseText);
                if (data.status == 200) {
                    $('.rodape-settings-alert').html('<i class="fa fa-check"></i> Configurações salvas com sucesso').show();
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/config/index';
                    }, 2000);
                } else {
                    $('.rodape-settings-alert').html('<i class="fa fa-remove"></i> Erro ao tentar atualizar o favicon.').show().removeClass('alert-success').addClass('alert-danger');
                    setTimeout(function () {
                        window.location.href = raiz + '/admin/config/index';
                    }, 2000);
                }
            }
        }
        request.open('post', '/admin/modulos/settings.php');
        request.send(formdata);
    });
});
function somenteNumeros(num) {
    var er = /[^0-9.]/;
    er.lastIndex = 0;
    var campo = num;
    if (er.test(campo.value)) {
        campo.value = "";
    }
}

function limpa_formulário_cep() {
    // Limpa valores do formulário de cep.
    $(".rua").val("");
    $(".bairro").val("");
    $(".cidade").val("");
    $(".estado").val("");
    //$("#ibge").val("");
}

//Quando o campo cep perde o foco.
$(".cep").blur(function () {

    //Nova variável "cep" somente com dígitos.
    var cep = $(this).val().replace(/\D/g, '');

    //Verifica se campo cep possui valor informado.
    if (cep != "") {

        //Expressão regular para validar o CEP.
        var validacep = /^[0-9]{8}$/;

        //Valida o formato do CEP.
        if (validacep.test(cep)) {

            //Preenche os campos com "..." enquanto consulta webservice.
            $(".rua").val("...");
            $(".bairro").val("...");
            $(".cidade").val("...");
            $(".estado").val("...");

            //Consulta o webservice viacep.com.br/
            $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

                if (!("erro" in dados)) {
                    //Atualiza os campos com os valores da consulta.
                    $(".rua").val(dados.logradouro);
                    $(".bairro").val(dados.bairro);
                    $(".cidade").val(dados.localidade);
                    $(".estado").val(dados.uf);
                    $(".numero").focus();
                    $('.error_cep').hide();
                } //end if.
                else {
                    //CEP pesquisado não foi encontrado.
                    limpa_formulário_cep();
                    $('.error_cep').html('<div class="alert alert-danger">CEP não encontrado.</div>').show();
                    $('.cep').attr('style', 'border:1px solid red !important;');
                }
            });
        } //end if.
        else {
            //cep é inválido.
            limpa_formulário_cep();
            $('.error_cep').html('<div class="alert alert-danger">Formato de CEP inválido.</div>').show();
            $('.cep').attr('style', 'border:1px solid red !important;');
        }
    } //end if.
    else {
        //cep sem valor, limpa formulário.
        limpa_formulário_cep();
    }
});

$(document).on('submit', 'form.form-user', function (e) {
    $('.btn_user').attr('disabled', true).text('Aguarde um momento...');
    e.preventDefault();
    $form = $(this);
    var formdata = new FormData($form[0]);
    var request = new XMLHttpRequest();
    request.upload.addEventListener('progress', function (e) {
        $('.btn_user').attr('disabled', true).text('Aguarde um momento...');
        var percent = Math.round(e.loaded / e.total * 100);
        $form.find('.progress-bar').width(percent + '%').html(percent + '%');
    });
    request.addEventListener('load', function (e) {
        $form.find('.progress-bar').addClass('progress-bar-success').html('Cadastro realizado com sucesso!');
    });

    request.onreadystatechange = function () {
        if (request.readyState == 1) {
            $('.btn_user').attr('disabled', false).text('Salvar');
        }
        if (request.readyState == 4) {
            var data = JSON.parse(request.responseText);
            if (data.status == 200) {
                $('.btn_user').attr('disabled', true).text('Aguarde um momento...');
                setTimeout(function () {
                    window.location.href = raiz + '/admin/' + data.type + '/editar/' + data.id
                }, 1000);
            } else {
                alert(data.msg);
                $('.btn_user').attr('disabled', false).text('Salvar');
            }
        }
    }
    request.open('post', '/admin/modulos/user.php');
    request.send(formdata);
});

$(document).ready(function () {

    var btn_cancelar = $("#btn-cancelar");
    var message = $("#message");

    btn_cancelar.on('click', function (event) {
        event.preventDefault();

        var id_assinatura = $(this).attr('data-id');

        $.ajax({
            url: '/admin/modulos/responds.php',
            type: 'post',
            data: 'acao=cancelar&id_assinatura=' + id_assinatura,
            dataType: 'json',
            beforeSend: function () {
                let mensagemAguarde = "<i class='fa fa-spinner fa-spin'></i>Aguarde enquanto estamos cancelando a assinatura";
                message.html('<div class="alert alert-info" style="text-align:center;">' + mensagemAguarde + '</div><br />');
            },
            success: function (retorno) {

                if (retorno.error == false) {
                    let mensagemSucesso = '<i class="fa fa-check" aria-hidden="true"></i>Você acabou de cancelar a assinatura do portal com sucesso.';
                    message.html('<div class="alert alert-info" style="text-align:center;">' + mensagemSucesso + '</div><br />');
                }

                if (retorno.error == true) {
                    message.html(showError(retorno));
                }

                setTimeout(function () {
                    location.reload();
                }, 3000)

            },
            error: function (error) {
                //console.log(error);
            }
        });


    });

});

function enviarApi(id) {

    $.ajax({
        url: '/admin/modulos/responds.php',
        type: 'post',
        data: 'acao=enviarOrdem&order_id=' + id,
        dataType: 'json',
        beforeSend: function () {
            $('.btn_order_' + id).html("<i class='fa fa-spinner fa-spin'></i>");
            $('.btn_status_' + id).html("<i class='fa fa-spinner fa-spin'></i>");
        },
        success: function (retorno) {

            if (retorno.status) {
                $('.btn_order_' + id).html("Enviar");
                $('.btn_status_' + id).html(retorno.status);
            } else {
                $('.btn_order_' + id).html(retorno.error);
            }
            setTimeout(function () {
                $('.btn_order_' + id).html("Enviar");
                $('.btn_status_' + id).html(retorno.status);
                location.reload();
            }, 3000)
        },
        error: function (error) {
            //console.log(error);
        }
    });
}
function updateStatus(id, idapi, order_id) {

    $.ajax({
        url: '/admin/modulos/responds.php',
        type: 'post',
        data: 'acao=statusOrdem&order_id=' + order_id + '&idapi=' + idapi + '&api_order_id=' + id,
        dataType: 'json',
        beforeSend: function () {
            $('.btn_status_' + order_id).html("<i class='fa fa-spinner fa-spin'></i>");
        },
        success: function (retorno) {

            if (retorno.status) {
                $('.btn_status_' + order_id).html(retorno.status);
            } else {
                $('.btn_status_' + order_id).html(retorno.error);
            }
            setTimeout(function () {
                $('.btn_status_' + order_id).html(retorno.status);
            }, 3000)
        },
        error: function (error) {
            //console.log(error);
        }
    });
}


