<?php

/**
 * Seo [ MODEL ]
 * Classe de apoio para o modelo LINK. Pode ser utilizada para gerar SSEO para as páginas do sistema!
 * 
 * @copyright (c) 2015, Alisson Maciel AGÊNCIA DIGITAL WEB LAB
 */
class Seo {

    private $File;
    private $Link;
    private $Data;
    private $Tags;

    /* DADOS POVOADOS */
    private $seoTags;
    private $seoData;

    function __construct($File, $Link) {
        $this->File = strip_tags(trim($File));
        $this->Link = strip_tags(trim($Link));
    }

    /**
     * <b>Obter MetaTags:</b> Execute este método informando os valores de navegação para que o mesmo obtenha
     * todas as metas como title, description, og, itemgroup, etc.
     * 
     * <b>Deve ser usada com um ECHO dentro da tag HEAD!</b>
     * @return HTML TAGS =  Retorna todas as tags HEAD
     */
    public function getTags() {
        $this->checkData();
        return $this->seoTags;
    }

    /**
     * <b>Obter Dados:</b> Este será automaticamente povoado com valores de uma tabela single para arquivos
     * como categoria, artigo, etc. Basta usar um extract para obter as variáveis da tabela!
     * 
     * @return ARRAY = Dados da tabela
     */
    public function getData() {
        $this->checkData();
        return $this->seoData;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    private function checkData() {
        if (!$this->seoData):
            $this->getSeo();
        endif;
    }

    private function getSeo() {
        $ReadSeo = new Read;
        $ReadEstado = new Read;
        $funcoes = new Funcoes;
        global $db, $pt, $mysqli,$linkto;
/*echo    '<pre>';
var_dump($linkto[1]);
echo    '</pre>';*/

        switch ($this->File):

            case 'posto':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'posto';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Posto - ' . SITENAME, 'Posto - ' . SITENAME, BASE . "/posto/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/posto/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            
            case 'depoimento':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'depoimento';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Depoimentos - ' . SITENAME, 'Depoimentos ' . SITENAME, BASE . "/depoimento/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/depoimento/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;

            case 'perguntas-frequentes':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'perguntas';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Perguntas Frequentes - ' . SITENAME, 'Perguntas Frequentes ' . SITENAME, BASE . "/perguntas-frequentes/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/perguntas-frequentes/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;


            case 'produtos':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'produtos';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Projetos - ' . SITENAME, 'Projetos do site ' . SITENAME, BASE . "/produtos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_subtitle, BASE . "/produtos/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'projetos':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'projetos';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Projetos - ' . SITENAME, 'Projetos do site ' . SITENAME, BASE . "/projetos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_subtitle, BASE . "/projetos/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'projeto':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'projetos';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Projetos - ' . SITENAME, 'Projetos do site ' . SITENAME, BASE . "/projetos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_subtitle, BASE . "/projetos/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'eventos':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'eventos';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Eventos - ' . SITENAME, 'Eventos do site ' . SITENAME, BASE . "/evenbtos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/eventos/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'galeria':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'portfolio';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Galeria - ' . SITENAME, 'Galeria ' . SITENAME, BASE . "/galeria/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/galeria/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;

            case 'pages':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'pages';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Página - ' . SITENAME, 'Página do site ' . SITENAME, BASE . "/pages/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                echo $funcoes->redirect(BASE);
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/pages/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'homepage':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'homepage';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Página - ' . SITENAME, 'Página do site ' . SITENAME, BASE . "/homepage/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/homepage/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;

            case 'portfolio':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'portfolio';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_id = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Portfolio - ' . SITENAME, 'Portfolio ' . SITENAME, BASE . "/portfolio/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/portfolio/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;

            case 'video':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'video';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Vídeos - ' . SITENAME, 'Vídeos ' . SITENAME, BASE . "/video/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/video/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;

            case 'banners':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'banner';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Banners - ' . SITENAME, 'Banners da ' . SITENAME, BASE . "/banner/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/banner/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;
                break;

            case 'servicos':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'servico';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Serviços - ' . SITENAME, 'Serviços que a Proceramica oferece', BASE . "/servico/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/servico/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'notification':
                global $pt, $db;
                $this->seoData = null;
                $this->seoTags = null;
                $url = '';
                if (isset($_POST['notificationCode'])):
                    $codigoNotificacao = $_POST['notificationCode'];
                    $url = "https://ws.pagseguro.uol.com.br/v2/transactions/notifications/{$codigoNotificacao}?email={$pt->config->config_email_pagseguro}&token={$pt->config->config_token_pagseguro}";
                elseif (isset($_GET['notificationCode'])):
                    $codigoNotificacao = $_GET['notificationCode'];
                    $url = "https://ws.pagseguro.uol.com.br/v2/transactions/notifications/{$codigoNotificacao}?email={$pt->config->config_email_pagseguro}&token={$pt->config->config_token_pagseguro}";
                endif;

                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $transaction_curl = curl_exec($curl);
                curl_close($curl);

                $transaction = simplexml_load_string(utf8_encode($transaction_curl));
                $transaction = json_encode($transaction);
                $transaction = json_decode($transaction);
                if ($transaction) {
                    $status = $transaction->status;

                    $read = new Read;
                    $read->ExeRead("ws_faturas", "where reference = :tr", "tr={$transaction->reference}");
                    if ($read->getResult()):
                        if ($transaction->status == 1):
                            $dados_fatura_create = array(
                                'status' => 'Aguardando pagamento',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;
                        if ($transaction->status == 2):
                            $dados_fatura_create = array(
                                'status' => 'Em análise',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;
                        if ($transaction->status == 3):
                            $dados_fatura_create = array(
                                'status' => 'Paga',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;
                        if ($transaction->status == 4):
                            $dados_fatura_create = array(
                                'status' => 'Disponivel',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;
                        if ($transaction->status == 5):
                            $dados_fatura_create = array(
                                'status' => 'Em disputa',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;
                        if ($transaction->status == 6):
                            $dados_fatura_create = array(
                                'status' => 'Devolvida',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;
                        if ($transaction->status == 7):
                            $dados_fatura_create = array(
                                'status' => 'Cancelada',
                                'bandeira' => BandeiraPagseguroBasico($transaction->paymentMethod->code),
                                'payment_method' => MeioPagamentoPagseguroBasico($transaction->paymentMethod->type),
                                'data_criacao' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                                'data_pagamento' => date('Y-m-d H:i:s', strtotime($transaction->lastEventDate)),
                            );
                        endif;

                        $update = $db->where('reference', $transaction->reference)->update("ws_faturas", $dados_fatura_create);

                    endif;
                }
                $this->Data = [
                    'Retorno - ' . SITENAME,
                    'Retorno - ' . SITENAME, BASE . "/retorno_pagseguro/",
                    BASE . "/images/noimage.gif.jpg",
                    KEYWORDS
                ];
                break;
            case 'sucesso':
                $this->seoData = null;
                $this->seoTags = null;
                if (isset($_GET['status']) && isset($_GET['gateway']) && $_GET['gateway'] == 'pagseguro') {
                    $this->Data = ['Sucesso - ' . $_GET['status'] . ' - ' . SITENAME, 'Assinatura criada com sucesso - ' . $_GET['status'] . ' - ' . SITENAME, BASE . "/sucesso/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                }

                $list_assinatura = $db->where('status', 'ACTIVE')->where('gateway', 'pagseguro')->orderBy('id', 'desc')->get('ws_assinaturas', 1000);
                if ($list_assinatura) {
                    foreach ($list_assinatura as $key_pagseguro => $assinaturas) {

                        $xmlAssinatura = (object) json_decode(curl_retorno_assinatura($assinaturas->code), JSON_PRETTY_PRINT);

                        if ($xmlAssinatura) {

                            $xmlFatura = (object) json_decode(curl_retorno_faturas($assinaturas->code), JSON_PRETTY_PRINT);

                            if ($xmlFatura) {
                                foreach ($xmlFatura->paymentOrders as $key_faturas => $value_fatura) {
                                    $value_fatura = (object) $value_fatura;

                                    if (isset($value_fatura->status) && $value_fatura->status == 1) {
                                        $statusFatura = 'Agendada';
                                        $update = $db->where('code', $assinaturas->code)->update("ws_assinaturas", array('proxima_fatura' => date('Y-m-d H:i:s', strtotime($value_fatura->schedulingDate))));
                                    } elseif (isset($value_fatura->status) && $value_fatura->status == 2) {
                                        $statusFatura = 'Processando';
                                        $array_user_fatura = array('user_assinante' => 0);
                                    } elseif (isset($value_fatura->status) && $value_fatura->status == 3) {
                                        $statusFatura = 'Não Processada';
                                        $array_user_fatura = array('user_assinante' => 0);
                                    } elseif (isset($value_fatura->status) && $value_fatura->status == 4) {
                                        $statusFatura = 'Suspensa';
                                        $array_user_fatura = array('user_assinante' => 0);
                                    } elseif (isset($value_fatura->status) && $value_fatura->status == 5) {
                                        $statusFatura = 'Pago';
                                        $array_user_fatura = array('user_assinante' => 1);
                                    } elseif (isset($value_fatura->status) && $value_fatura->status == 6) {
                                        $statusFatura = 'Não Paga';
                                        $array_user_fatura = array('user_assinante' => 0);
                                    }
                                    $list_fatura = $db->where('acquirer_name', 'pagseguro')->where('id_invoice', $value_fatura->code)->where('id_user', $assinaturas->customer_id)->getOne('ws_faturas');

                                    if ($list_fatura) {

                                        $dados_fatura_update = array(
                                            'amount' => $value_fatura->amount,
                                            'status' => $statusFatura,
                                            'acquirer_name' => 'pagseguro',
                                            'code_assinatura' => $assinaturas->code,
                                            'type' => 'assinatura',
                                            'payment_method' => strtolower($assinaturas->payment_method),
                                            'proxima_cobranca' => date('Y-m-d H:i:s', strtotime($value_fatura->schedulingDate)),
                                            'data_criacao' => date('Y-m-d H:i:s', strtotime($value_fatura->lastEventDate)),
                                        );
                                        $update = $db->where('id_invoice', $value_fatura->code)->update('ws_faturas', $dados_fatura_update);
                                    } else {
                                        $dados_fatura_create = array(
                                            'amount' => $value_fatura->amount,
                                            'id_invoice' => $value_fatura->code,
                                            'status' => $statusFatura,
                                            'id_user' => $assinaturas->customer_id,
                                            'code_assinatura' => $assinaturas->code,
                                            'acquirer_name' => 'pagseguro',
                                            'type' => 'assinatura',
                                            'payment_method' => strtolower($assinaturas->payment_method),
                                            'proxima_cobranca' => date('Y-m-d H:i:s', strtotime($value_fatura->schedulingDate)),
                                            'data_criacao' => date('Y-m-d H:i:s', strtotime($value_fatura->lastEventDate)),
                                        );
                                        $insert = $db->insert('ws_faturas', $dados_fatura_create);
                                    }

                                    $list_fatura_ultima = $db->where('acquirer_name', 'pagseguro')->where('id_invoice', $value_fatura->code)->orderBy('proxima_cobranca', 'asc')->getOne('ws_faturas');
                                    $list_plan = $db->where('post_id', $assinaturas->plan_id)->getOne('ws_posts');
                                    $list_user = $db->where('user_id', $list_fatura_ultima->id_user)->getOne('ws_users');
                                    if ($list_fatura_ultima->status == 'Pago') {

                                        $data_user = array(
                                            'user_creditos' => $list_user->user_creditos + $list_plan->post_quantidade,
                                            'user_assinante' => 1,
                                        );

                                        $update = $db->where('user_id', $list_fatura_ultima->id_user)->where('user_assinante', 0)->update('ws_users', $data_user);
                                    } elseif ($list_fatura_ultima->status == 'Não Processada') {
                                        $data_user = array(
                                            'user_assinante' => 0
                                        );
                                        $update = $db->where('user_id', $list_fatura_ultima->id_user)->update('ws_users', $data_user);
                                    } elseif ($list_fatura_ultima->status == 'Processando') {
                                        $data_user = array(
                                            'user_assinante' => 0
                                        );
                                        $update = $db->where('user_id', $list_fatura_ultima->id_user)->update('ws_users', $data_user);
                                    } elseif ($list_fatura_ultima->status == 'Não Paga') {
                                        $data_user = array(
                                            'user_assinante' => 0
                                        );
                                        $update = $db->where('user_id', $list_fatura_ultima->id_user)->update('ws_users', $data_user);
                                    } elseif ($list_fatura_ultima->status == 'Suspensa') {
                                        $data_user = array(
                                            'user_assinante' => 0
                                        );
                                        $update = $db->where('user_id', $list_fatura_ultima->id_user)->update('ws_users', $data_user);
                                    }
                                    $update = $db->where('code', $assinaturas->code)->update("ws_assinaturas", array('status' => $xmlAssinatura->status));
                                }
                            }
                            $this->Data = ['Status da assinatura ' . $xmlAssinatura->status . ' - ' . SITENAME, 'Status da assinatura ' . $xmlAssinatura->status . ' - ' . SITENAME, BASE . "/sucesso/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                        }
                    }
                }
                //}
                $delete = $db->rawQuery('DELETE FROM ws_faturas WHERE id_invoice IS NULL');
                $data = array('status' => 200);
                break;
            case 'planos':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'planos';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Planos - ' . SITENAME, 'Nossos planos', BASE . "/planos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $_SESSION['plano'] = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/planos/{$extract->post_name}", BASE . "/uploads/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                endif;

                break;
            case 'catalogos':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND');
                $type = 'catalogos';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Catálogos - ' . SITENAME, 'Catálogos', BASE . "/catalogos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/catalogos/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                    //echo $funcoes->redirect(BASE.'/catalogos');
                endif;

                break;
            case 'manuais':
                $Admin = (isset($_SESSION['userlogin']->user_level) && $_SESSION['userlogin']->user_level == 3 ? true : false);
                $Check = ($Admin ? '' : 'post_status = 1 AND'); 
                $type = 'manuais';
                $ReadSeo->ExeRead("ws_posts", "WHERE {$Check} post_name = :link AND post_type = :type", "link={$this->Link}&type={$type}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Manuais - ' . SITENAME, 'Manuais', BASE . "/manuais/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->post_title . ' - ' . SITENAME, $extract->post_content, BASE . "/manuais/{$extract->post_name}", BASE . "/{$extract->post_cover}", KEYWORDS];

                    $ArrUpdate = ['post_views' => $extract->post_views + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_posts", $ArrUpdate, "WHERE post_id = :postid", "postid={$extract->post_id}");
                    echo $funcoes->redirect(BASE.'/manuais');
                endif;

                break;
            case 'categorias':
                //$ReadSeo->ExeRead("ws_categories", "WHERE category_name = :link", "link={$this->Link}");
                $ReadSeo->FullRead("select *,term_id AS category_id from ws_terms where slug = :link", "link={$this->Link}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->name . ' - ' . SITENAME, $extract->name, BASE . "/categorias/{$extract->slug}", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
//$ReadSeos=$ReadSeo->FullRead("select * from ws_term_taxonomy where parent = :parent", "link={$extract->term_id}");
//                    $ArrUpdate = ['count' => $ReadSeos[0]->count + 1];
//                    $Update = new Update();
//                    $Update->ExeUpdate("ws_term_taxonomy", $ArrUpdate, "WHERE parent = :catid", "catid={$extract->term_id}");
                endif;
                break;
            case 'categoria':
                //$ReadSeo->ExeRead("ws_categories", "WHERE category_name = :link", "link={$this->Link}");
                $ReadSeo->FullRead("select t.*,c.* from ws_term_taxonomy t, ws_terms c where t.term_id = c.term_id and c.slug = :link", "link={$this->Link}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                else:
                    $extract = $ReadSeo->getResult()[0];
                    $this->seoData = $ReadSeo->getResult()[0];
                    $this->Data = [$extract->name . ' - ' . SITENAME, $extract->description, BASE . "/categorias/{$extract->slug}", INCLUDE_PATH . '/images/logo.png', KEYWORDS];

                    $ArrUpdate = ['count' => $extract->count + 1];
                    $Update = new Update();
                    $Update->ExeUpdate("ws_term_taxonomy", $ArrUpdate, "WHERE term_taxonomy_id = :catid", "catid={$extract->term_taxonomy_id}");
                endif;
                break;

            case 'pesquisa':
                $ReadSeo->ExeRead("ws_posts", "WHERE post_status = 1 AND (post_title LIKE '%' :link '%' OR post_content LIKE '%' :link '%')", "link={$this->Link}");
                if (!$ReadSeo->getResult()):
                    $this->seoData = null;
                    $this->seoTags = null;
                else:
                    $this->seoData['count'] = $ReadSeo->getRowCount();
                    $this->Data = ["Pesquisa por: {$this->Link}" . ' - ' . SITENAME, "Sua pesquisa por {$this->Link} retornou {$this->seoData['count']} resultados!", BASE . "/pesquisa/{$this->Link}", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                endif;
                break;

            case 'seja-cliente':
                $this->Data = ["Seja cliente" . ' - ' . SITENAME, "Seja cliente", BASE . "/seja-cliente", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                break;
            case 'carrinho-de-orcamento':
                $this->Data = ["Carrinho de Orçamento" . ' - ' . SITENAME, "Carrinho de Orçamento", BASE . "/carrinho-de-orcamento", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                break;
            case 'minha-assinatura':
                if (isset($_SESSION['userlogin'])) {
                    $this->Data = ["Minha Assinatura" . ' - ' . SITENAME, "Minha Assinatura", BASE . "/minha-assinatura", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                } else {
                   header('location:'.BASE);
                }
                break;
            case 'afiliados':
                if (isset($_SESSION['userlogin'])) {
                    $this->Data = ["Programa de Afiliados" . ' - ' . SITENAME, "Programa de Afiliados", BASE . "/afiliados", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                } else {
                    header('location:'.BASE);
                }
                break;
            case 'curtidas-automaticas':
                if (isset($_SESSION['userlogin'])) {
                    $this->Data = ["Curtidas Automáticas" . ' - ' . SITENAME, "Curtidas Automáticas", BASE . "/curtidas-automaticas", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                } else {
                    header('location:'.BASE);
                }
                break;
            case 'minhas-ordens':
                if (isset($_SESSION['userlogin'])) {
                    $this->Data = ["Minhas Ordens" . ' - ' . SITENAME, "Minhas Ordens", BASE . "/minhas-ordens", INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                } else {
                  header('location:'.BASE);
                }
                break;
            case 'detalhes':

                if (isset($_SESSION['userlogin'])) {

                    $ReadSeo->FullRead("SELECT a.*, u.*,p.* FROM ws_assinaturas a, ws_users u, ws_posts p WHERE a.id = :link AND a.customer_id = :user AND a.customer_id = u.user_id AND p.post_id = a.plan_id", "link={$this->Link}&user={$_SESSION['userlogin']->user_id}");
                    if (!$ReadSeo->getResult()):
                        $this->seoData = null;
                        $this->seoTags = null;
                        $funcoes->redirect(BASE.'/minha-assinatura');
                    else:
                        $extract = $ReadSeo->getResult()[0];
                        $this->seoData = $ReadSeo->getResult()[0];
                        $this->Data = ['Detalhes da assinatura #' . $extract->id . ' - ' . SITENAME, SITENAME, BASE . "/detalhes/{$extract->id}", INCLUDE_PATH . '/images/logo.png', KEYWORDS];

                    endif;
                } else {
                   header('location:'.BASE);
                }

                break;
            case 'faturas':

                if (isset($_SESSION['userlogin'])) {

                    $ReadSeo->FullRead("SELECT a.*, u.*,f.*,f.id AS fid FROM ws_assinaturas a, ws_users u, ws_faturas f WHERE a.id = :link AND a.customer_id = :user AND f.code_assinatura = a.code", "link={$this->Link}&user={$_SESSION['userlogin']->user_id}");
                    if (!$ReadSeo->getResult()):
                        $this->seoData = null;
                        $this->seoTags = null;
                        header('location:' . BASE . '/minha-assinatura');
                    else:
                        $extract = $ReadSeo->getResult()[0];
                        $this->seoData = $ReadSeo->getResult()[0];
                        $this->Data = ['Faturas - ' . SITENAME, SITENAME, BASE . "/faturas/{$extract->id}", INCLUDE_PATH . '/images/logo.png', KEYWORDS];

                    endif;
                } else {
                  header('location:'.BASE);
                }

                break;
            case 'cadastro':
                $this->Data = ["Cadastre-se" . ' - ' . SITENAME, "Cadastre-se", BASE . "/cadastro/{$this->Link}", INCLUDE_PATH . '/images/logo.png', KEYWORDS];

                if (isset($pt->config->user_registration) && $pt->config->user_registration == 'off') {
                   header('location:'.BASE);
                }
                break;

            case 'painel':
                if (isset($_SESSION['userlogin'])) {

                    $instagram = GetInstagram($this->Link);
                    if ($instagram) {
                        $this->Data = [$instagram->full_name . ' (@' . $instagram->username . ') - Painel de controle - ' . SITENAME,
                            $instagram->full_name . ' (@' . $instagram->username . ') - Painel de controle ' . SITENAME,
                            BASE . "/painel/" . $instagram->username, $instagram->profile_picture_url, KEYWORDS];
                        $update = $db->where('id', $instagram->id)->update('ws_users_instagram', array('selected' => 1, 'timestamp' => time()));
                        $_SESSION['username_instagram'] = $this->Link;
                        $pt->instagram = ToObject($instagram);
                    } else {
                        $this->Data = ['Painel de controle - ' . SITENAME, 'Painel de controle ' . SITENAME, BASE . "/painel/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                    }
                } else {
                   header('location:'.BASE);
                }

                break;
            case 'login':
                $this->Data = ['Login - ' . SITENAME, 'Login ' . SITENAME, BASE . "/login/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                break;

            case 'perfil':
                if (isset($_SESSION['userlogin']) AND $_SESSION['userlogin'] == true):
                    $this->Data = ['Meu perfil - ' . SITENAME, 'Meu perfil ' . SITENAME, BASE . "/perfil/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    header('location:'.BASE);
                endif;
                break;

            case 'payment_success':
                $this->Data = ['Status de pagamento - ' . SITENAME, 'Status de pagamento ' . SITENAME, BASE . "/payment_success/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                break;
            case 'meus-pagamentos':
                if (isset($_SESSION['userlogin']) AND $_SESSION['userlogin'] == true):
                    $this->Data = ['Meus pagamentos - ' . SITENAME, 'Meus pagamentos ' . SITENAME, BASE . "/meus-pagamentos/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                   header('location:'.BASE);
                endif;
                break;

            case 'meus-exames':
                if (isset($_SESSION['userlogin']) AND $_SESSION['userlogin'] == true):
                    $this->Data = ['Meus exames - ' . SITENAME, 'Meus exames ' . SITENAME, BASE . "/meus-exames/", BASE . "/images/noimage.gif.jpg", KEYWORDS];
                else:
                    header('location:'.BASE);
                endif;
                break;

            case 'index':
                $this->Data = ['Home - ' . SITENAME, SITEDESC, BASE, INCLUDE_PATH . '/assets/images/logo.png', KEYWORDS];
                break;

            case 'contato':
                $id = 1;
                global $pt;
                if (!$pt->config):
                    $this->seoData = null;
                    $this->seoTags = null;
                    $this->Data = ['Fale Conosco - ' . SITENAME . ' - ' . SITEDESC, SITEDESC, BASE, INCLUDE_PATH . '/images/logo.png', KEYWORDS];
                else:
                    $extract = $pt->config;
                    $this->seoData = $pt->config;
                    $this->Data = ['Fale Conosco - ' . SITENAME, SITEDESC, BASE . "/contato/", BASE . '/images/logo.png', KEYWORDS];
                endif;
                break;

            default :
                $this->Data = [SITENAME . ' - 404 Oppsss, Nada encontrado!', SITEDESC, BASE . '/404', INCLUDE_PATH . '/images/logo.png', KEYWORDS];

        endswitch;

        if ($this->Data):
            $this->setTags();
        endif;
    }

    private function setTags() {
        $Check = new Check;
        $this->Tags['Title'] = $this->Data[0];
        $this->Tags['Content'] = $Check->Words(html_entity_decode($this->Data[1]), 25);
        $this->Tags['Link'] = $this->Data[2];
        $this->Tags['Image'] = $this->Data[3];
        $this->Tags['Keywords'] = $this->Data[4];

        $this->Tags = array_map('strip_tags', $this->Tags);
        $this->Tags = array_map('trim', $this->Tags);

        $this->Data = null;

        $this->seoTags = '<title>' . $this->Tags['Title'] . '</title> ' . "\n";
        $this->seoTags .= '<meta name="description" content="' . $this->Tags['Content'] . '"/>' . "\n";
        $this->seoTags .= '<meta name="robots" content="index, follow" />' . "\n";
        $this->seoTags .= '<link rel="canonical" href="' . $this->Tags['Link'] . '">' . "\n\n";


        $this->seoTags .= '<meta property="og:site_name" content="' . SITENAME . '" />' . "\n";
        $this->seoTags .= '<meta property="og:locale" content="pt_BR" />' . "\n";
        $this->seoTags .= '<meta property="og:title" content="' . $this->Tags['Title'] . '" />' . "\n";
        $this->seoTags .= '<meta property="og:description" content="' . $this->Tags['Content'] . '" />' . "\n";
        $this->seoTags .= '<meta property="og:image" content="' . $this->Tags['Image'] . '" />' . "\n";
        $this->seoTags .= '<meta property="og:url" content="' . $this->Tags['Link'] . '" />' . "\n";
        $this->seoTags .= '<meta property="og:type" content="article" />' . "\n";
        $this->seoTags .= "\n";

        $this->seoTags .= '<meta itemprop="name" content="' . $this->Tags['Title'] . '">' . "\n";
        $this->seoTags .= '<meta itemprop="description" content="' . $this->Tags['Content'] . '">' . "\n";
        $this->seoTags .= '<meta itemprop="url" content="' . $this->Tags['Link'] . '">' . "\n";

        $this->Tags = null;
    }

}
