<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Carrinho
 *
 * @author WEBLAB
 */
class Carrinho {

    private $pref = "qualiterme_";

    private function existe($id) {
        if (!isset($_SESSION[$this->pref . 'carrinho'])) {
            $_SESSION[$this->pref . 'carrinho'] = array();
        }

        if (!isset($_SESSION[$this->pref . 'carrinho'][$id])) {
            return false;
        } else {
            return true;
        }
    }

//verifica a existencia do carrinho e da session como um array

    public function verificaAdiciona($id) {
        if (!$this->existe($id)) {
            $_SESSION[$this->pref . 'carrinho'][$id] = 1;
        } else {
            $_SESSION[$this->pref . 'carrinho'][$id] += 1;
        }
    }

//verifica e adiciona mais um carrinho ao carrinho

    private function prodExiste($id) {
        if (isset($_SESSION[$this->pref . 'carrinho'][$id])) {
            return true;
        } else {
            return false;
        }
    }

//verifica se o carrinho existe

    public function deletarProduto($id) {
        if (!$this->prodExiste($id)) {
            return false;
        } else {
            unset($_SESSION[$this->pref . 'carrinho'][$id]);
            return true;
        }
    }

//deletar carrinho do carrinho de compras

    private function isArray($post) {
        if (is_array($post)) {
            return true;
        } else {
            return false;
        }
    }

//verifica se o post passado por parametro Ã© ou nÃ£o um array

    public function atualizarQuantidades($post) {
        if ($this->isArray($post)) {
            foreach ($post as $id => $qtd) {
                $id = (int) $id;
                $qtd = (int) $qtd;

                if ($qtd != '') {
                    $_SESSION[$this->pref . 'carrinho'][$id] = $qtd;
                } else {
                    unset($_SESSION[$this->pref . 'carrinho'][$id]);
                }
            }
            return true;
        } else {
            return false;
        }//se nÃ£o for um array
    }

//deleta ou atualiza quantidades referente a um carrinho no nosso carrinho de compras

    public function setarByPost($post) {
        if ($this->isArray($post)) {
            foreach ($post as $id => $qtd) {
                $id = (int) $id;
                $qtd = (int) $qtd;

                if (!isset($_SESSION[$this->pref . 'carrinho'][$id])) {
                    $_SESSION[$this->pref . 'carrinho'][$id] = $qtd;
                } else {
                    $_SESSION[$this->pref . 'carrinho'][$id] += $qtd;
                }
            }
            return true;
        } else {
            return false;
        }//se nÃ£o for um array
    }

    public function setarByModelo($post) {
        if ($this->isArray($post)) {
            foreach ($post as $id => $modelo) {
                $id = (int) $id;
                $modelo = $modelo;

                if (!isset($_SESSION[$this->pref . 'modelo'][$id])) {
                    $_SESSION[$this->pref . 'modelo'][$id] = $modelo;
                } else {
                    $_SESSION[$this->pref . 'modelo'][$id] = $modelo;
                }
            }
            return true;
        } else {
            return false;
        }//se nÃ£o for um array
    }

    public function qtdProdutos() {
        if (isset($_SESSION[$this->pref . 'carrinho'])):
            return count($_SESSION[$this->pref . 'carrinho']);
        else:
            return 0;
        endif;
    }

    //FUNÃ‡ÃƒO PARA CALCULO DO FRETE
    public function calculaFrete($cod_servico, $cep_origem, $cep_destino, $peso, $altura = '2', $largura = '11', $comprimento = '16', $valor_declarado = '0.50') {
        # CÃ³digo dos ServiÃ§os dos Correios
        # 41106 PAC sem contrato
        # 40010 SEDEX sem contrato
        # 40045 SEDEX a Cobrar, sem contrato
        # 40215 SEDEX 10, sem contrato

        $correios = "http://ws.correios.com.br/calculador/CalcPrecoPrazo.aspx?nCdEmpresa=&sDsSenha=&sCepOrigem=" . $cep_origem . "&sCepDestino=" . $cep_destino . "&nVlPeso=" . $peso . "&nCdFormato=1&nVlComprimento=" . $comprimento . "&nVlAltura=" . $altura . "&nVlLargura=" . $largura . "&sCdMaoPropria=n&nVlValorDeclarado=" . $valor_declarado . "&sCdAvisoRecebimento=n&nCdServico=" . $cod_servico . "&nVlDiametro=0&StrRetorno=xml";
        $xml = simplexml_load_file($correios);
        if ($xml->cServico->Erro == '0')
            return $xml->cServico->Valor;
        else
            return false;
    }

    public function listagemGeral($id) {
        $this->id = (int) $id;
        $read = new Read;
        $read->ExeRead("loja_carrinhos", "where idProduto = :id", "id={$this->id}");
        if ($read->getResult()):
            return $read->getResult()[0];
        endif;
    }

}
