<?php
 
class ApiPadrao {
    
    public $api_url = ''; // API URL
    public $api_key = ''; // Your API key
    public $refil = 4;
    public $tipo = 'REALIZAR_PEDIDO';
    public $idUsuario = null;
    public $statusParam;
    public $saldoParam;

    function __construct($url, $token, $idUsuario = null, $tipo = null, $statusParam = null, $saldoParam = null) {

        $this->statusParam = $statusParam;
        $this->api_url = $url;
        $this->api_key = $token;
        $this->tipo = $tipo;

        if (!empty($saldoParam) && $saldoParam == 'balance'):
            $this->saldoParam = 'balance';
        else:
            $this->saldoParam = $saldoParam;
        endif;
        if (!empty($idUsuario)):
            $this->idUsuario = $idUsuario;
        else:
            unset($idUsuario);
        endif;
        if (!empty($tipo)):
            $this->tipo = $tipo;
        else:
            unset($tipo);
        endif;
    }

    public function order($data) { // add order
        $post = array_merge(array('api_token' => $this->api_key, 'key' => $this->api_key, 'keyInterno' => $this->api_key, 'action' => 'add', 'actionInterno' => 'add'), $data);
        return json_decode($this->connect($post), true);
    }

    public function status($order_id) { // get order status
        return json_decode($this->connect(array('api_token' => $this->api_key,
                    'key' => $this->api_key,
                    'apiKey' => $this->api_key,
                    'keyInterno' => $this->api_key,
                    'action' => $this->statusParam,
                    'actionType' => $this->statusParam,
                    'actionInterno' => $this->statusParam,
                    'id_pedido' => $order_id,
                    'order' => $order_id
                )), true);
    }

    public function services() { // get services
        return json_decode($this->connect(array('api_token' => $this->api_key,
                    'key' => $this->api_key,
                    'apiKey' => $this->api_key,
                    'action' => 'services',
                    'actionType' => 'services',
                    'keyInterno' => $this->api_key,
                    'actionInterno' => 'services',
                )), true);
    }

    public function balance($token = null, $saldoParam = null) { // get balance
        $this->api_key = $token;
        $this->saldoParam = $saldoParam;

        $balance = json_decode($this->connect(array('api_token' => $this->api_key,
                    'key' => $this->api_key,
                    'apiKey' => $this->api_key,
                    'action' => $this->saldoParam,
                    'actionType' => $this->saldoParam,
                    'keyInterno' => $this->api_key,
                    'actionInterno' => $this->saldoParam,
                )), true);
        
        return $balance;
    }

    public function refil($order_id) {
        return json_decode($this->connect(array('api_token' => $this->api_key,
                    'key' => $this->api_key,
                    'action' => $this->refil,
                    'id' => $order_id,
        )));
    }

    private function connect($post) {
        $_post = Array();
        if (is_array($post)) {
            foreach ($post as $name => $value) {
                $_post[] = $name . '=' . urlencode($value);
            }
        }

        $ch = curl_init($this->api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        if (is_array($post)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, join('&', $_post));
        }
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        $result = curl_exec($ch);
        if (curl_errno($ch) != 0 && empty($result)) {
            $result = false;
        }
        curl_close($ch);
        return $result;
    }

}

?>