<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of APISocialNX
 *
 * @author WEBLAB
 */
class APISocialNX {

    private $API_URL = '';
    private $API_TOKEN = '';
    private $action;

    function __construct($API_URL = null, $API_TOKEN = null, $action = null) {
        $this->API_URL = $API_URL;
        $this->API_TOKEN = $API_TOKEN;
        $this->action = $action;
    }

    public function order($data) { // add order
        $post = array_merge([
            'api_token' => $this->API_TOKEN,
            'action' => $this->action
                ], $data);

        return json_decode($this->connect($post));
    }

    public function balance() {
        $ch = curl_init();

        $token = $this->API_TOKEN;

        curl_setopt($ch, CURLOPT_URL, $this->API_URL);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "token=" . $token . "&action=" . $this->action);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close($ch);
        $json = json_decode($server_output, true);

        echo $json['saldo']; //Retorna o saldo no painel
    }

    public function refil($order_id) {
        $ch = curl_init();

        $token = $this->API_TOKEN;
        $id_pedido = $order_id;

        curl_setopt($ch, CURLOPT_URL, $this->API_URL);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "token=" . $token . "&action=" . $this->action . "&id=" . $id_pedido);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close($ch);
        $json = json_decode($server_output, true);

        print_r($json); //Para ver as informacoes disponiveis.
    }

    public function status($order_id) { // get order status
        $ch = curl_init();

        $token = $this->API_TOKEN;
        $id_pedido = $order_id;

        curl_setopt($ch, CURLOPT_URL, $this->API_URL);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "token=" . $token . "&action=" . $this->action . "&id=" . $id_pedido);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close($ch);
        $json = json_decode($server_output, true);

        echo $json['status']; //Retorna o status do pedido

        print_r($json); //Para ver as informacoes disponiveis.
    }

    private function connect($post) {
        $ch = curl_init();

        $token = $this->API_TOKEN;
        $id_pedido = $post['order'];
        $link = $post['link'];
        $quantidade = $post['quantity'];
        $id_service = $post['package_id'];

        curl_setopt($ch, CURLOPT_URL, $this->API_URL);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "token=" . $token . "&action=" . $post['action'] . "&service=" . $id_service . "&link=" . $link . "&quantity=" . $quantidade);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close($ch);
        $json = json_decode($server_output, true);

        echo $json['id']; //Retorna o ID do pedido.
    }

}
