<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of API
 *
 * @author WEBLAB
 */
class API {

    private $API_URL = '';
    private $API_TOKEN = '';
    private $action;

    function __construct($API_URL = null, $API_TOKEN = null, $action = null) {
        $this->API_URL = $API_URL;
        $this->API_TOKEN = $API_TOKEN;
        $this->action = $action;
    }

    public function order($data) {
        $post = array_merge([
            'key' => $this->API_TOKEN,
            'action' => $this->action
                ], $data);

        return json_decode($this->connect($post));
    }

    public function status($order_id) {
        return json_decode($this->connect([
                    'key' => $this->API_TOKEN,
                    'action' => $this->action,
                    'order' => $order_id
        ]));
    }

    public function multiStatus($order_id) {
        return json_decode($this->connect(array(
                    'key' => $this->API_TOKEN,
                    'action' => $this->action,
                    'order' => implode(",", (array) $order_id)
        )));
    }

    public function balance() {
        return json_decode($this->connect([
                    'key' => $this->API_TOKEN,
                    'action' => $this->action,
        ]));
    }

    public function packages() {
        return json_decode($this->connect([
                    'key' => $this->API_TOKEN,
                    'action' => 'packages',
        ]));
    }

    public function services() {
        return json_decode($this->connect(array(
                    'key' => $this->API_TOKEN,
                    'action' => 'services',
        )));
    }

    private function connect($post) {
        $_post = Array();
        foreach ($post as $name => $value) {
            $_post[$name] = urlencode($value);
        }

        $ch = curl_init($this->API_URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));

        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        $result = curl_exec($ch);
        if (curl_errno($ch) != 0 && empty($result)) {
            $result = false;
        }
        curl_close($ch);
        return $result;
    }

    private function curl($dados = "", $tipo = "", $meta = "", $GET = false) {


        if ($GET) {
            $curl = curl_init("{$this->API_URL}/" . $dados);
        } else {
            $curl = curl_init("{$this->API_URL}");
        }



        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        /* PARA METODOS POST, PUT e DELETE */
        if (!$GET)
            curl_setopt($curl, $meta, $tipo);
        if (!$GET)
            curl_setopt($curl, CURLOPT_POSTFIELDS, $dados);

        //curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept: application/json', 'Content-Type: application/json'));

        $curl_response = curl_exec($curl);
        curl_close($curl);

        return $curl_response;
    }

}

/*/* Examples

$api = new Api();

// Fetch Packages
$packages = $api->packages();

// Check balance
$balance = $api->balance();

// Add order
$order = $api->order(array('package' => 1, 'link' => 'http://example.com/link', 'quantity' => 100));

// Add Custom comments order
$order = $api->order(array('package' => 11, 'link' => 'http://example.com/link', 'quantity' => 4, 'comments' => "good pic\ngreat photo\n:)\n;)")); # Custom Comments

// Check Order status
$status = $api->status($order->order);*/
