<?php

/**
 * ValidaCpf.class.php[TIPO]
 * Descricao
 * @copyright (c) 2015, Alisson Maciel, Agencia Digital Web Lab
 */
class ValidaCpf {
    public function setCpf($cpf, $string, $uso=null){
        if(!$cpf):
            return WLMsg("Informe o CPF", WL_ALERT);
        elseif($cpf == $string):
            return WLMsg("Este formato de CPF, não é mais utilizado", WL_INFOR);
        elseif($cpf == $uso):
            return WLMsg("CPF em uso", WL_ALERT);
        elseif(!preg_match('/^[0-9]*$/i', $cpf) && strlen($cpf) != 11):
            return WLMsg("CPF inválido", WL_ERROR);
        else:
            return WLMsg("CPF válido", WL_ACCEPT);
        endif;
    }
}
